package db

import (
	"errors"
	"testing"

	"code.justin.tv/web/users-service/database/mocks"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestUnbanBackend(t *testing.T) {
	Convey("When calling UnbanUser", t, func() {
		sdb := &mocks.Querier{}
		mdb := &mocks.Querier{}
		ub := &siteDBImpl{sdb: sdb, mdb: mdb}
		ctx := context.Background()

		Convey("with an id", func() {
			ID := "5"
			tx := mocks.Tx{}
			Convey("and the DB executes sql without error", func() {
				tx.On("Commit").Return(nil)
				tx.On("Exec", ctx, "unban_set_ump_properties", sqlUnbanSetUMPProps, []interface{}{ID, 2, 2}).Return(&mocks.Result{}, nil)
				tx.On("Exec", ctx, "unban_set_users_properties", sqlUnbanSetUsersProps, []interface{}{ID}).Return(&mocks.Result{}, nil)
				mdb.On("Begin", ctx, "unban_user_transaction").Return(&tx, nil)

				err := ub.UnbanUser(ctx, ID, 2, 2)
				So(err, ShouldBeNil)
			})

			Convey("and the DB executes sql with error", func() {
				tx.On("Commit").Return(nil)
				tx.On("Rollback").Return(nil)
				tx.On("Exec", ctx, "unban_set_ump_properties", sqlUnbanSetUMPProps, []interface{}{ID, 2, 2}).Return(&mocks.Result{}, errors.New("Garbage"))
				tx.On("Exec", ctx, "unban_set_users_properties", sqlUnbanSetUsersProps, []interface{}{ID}).Return(&mocks.Result{}, errors.New("Garbage"))
				mdb.On("Begin", ctx, "unban_user_transaction").Return(&tx, nil)

				err := ub.UnbanUser(ctx, ID, 2, 2)
				So(err, ShouldNotBeNil)
			})
		})

	})
}
