// Code generated by mockery v1.0.0
package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"
import time "time"

import util "code.justin.tv/web/users-service/backend/util"

// Backend is an autogenerated mock type for the Backend type
type Backend struct {
	mock.Mock
}

// AlterDMCAStrike provides a mock function with given fields: ctx, id, delta
func (_m *Backend) AlterDMCAStrike(ctx context.Context, id string, delta int) error {
	ret := _m.Called(ctx, id, delta)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, int) error); ok {
		r0 = rf(ctx, id, delta)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// BanUser provides a mock function with given fields: ctx, id, warn, tosBan, dmcaStrikes, tosStrikes
func (_m *Backend) BanUser(ctx context.Context, id string, warn bool, tosBan bool, dmcaStrikes int, tosStrikes int) error {
	ret := _m.Called(ctx, id, warn, tosBan, dmcaStrikes, tosStrikes)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, bool, bool, int, int) error); ok {
		r0 = rf(ctx, id, warn, tosBan, dmcaStrikes, tosStrikes)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CreateUser provides a mock function with given fields: ctx, up
func (_m *Backend) CreateUser(ctx context.Context, up *models.CreateUserProperties) error {
	ret := _m.Called(ctx, up)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *models.CreateUserProperties) error); ok {
		r0 = rf(ctx, up)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CreateUserEmail provides a mock function with given fields: ctx, id, code
func (_m *Backend) CreateUserEmail(ctx context.Context, id string, code string) error {
	ret := _m.Called(ctx, id, code)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = rf(ctx, id, code)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetBannedUsers provides a mock function with given fields: ctx, until
func (_m *Backend) GetBannedUsers(ctx context.Context, until time.Time) ([]models.Properties, error) {
	ret := _m.Called(ctx, until)

	var r0 []models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, time.Time) []models.Properties); ok {
		r0 = rf(ctx, until)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, time.Time) error); ok {
		r1 = rf(ctx, until)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGlobalPrivilegedUsers provides a mock function with given fields: ctx, roles
func (_m *Backend) GetGlobalPrivilegedUsers(ctx context.Context, roles []string) (*models.GlobalPrivilegedUsers, error) {
	ret := _m.Called(ctx, roles)

	var r0 *models.GlobalPrivilegedUsers
	if rf, ok := ret.Get(0).(func(context.Context, []string) *models.GlobalPrivilegedUsers); ok {
		r0 = rf(ctx, roles)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.GlobalPrivilegedUsers)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string) error); ok {
		r1 = rf(ctx, roles)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetLogins provides a mock function with given fields: ctx, logins
func (_m *Backend) GetLogins(ctx context.Context, logins []string) ([]models.LoginProperties, error) {
	ret := _m.Called(ctx, logins)

	var r0 []models.LoginProperties
	if rf, ok := ret.Get(0).(func(context.Context, []string) []models.LoginProperties); ok {
		r0 = rf(ctx, logins)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]models.LoginProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string) error); ok {
		r1 = rf(ctx, logins)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserBlock provides a mock function with given fields: ctx, login
func (_m *Backend) GetUserBlock(ctx context.Context, login string) (*models.BlockProperties, error) {
	ret := _m.Called(ctx, login)

	var r0 *models.BlockProperties
	if rf, ok := ret.Get(0).(func(context.Context, string) *models.BlockProperties); ok {
		r0 = rf(ctx, login)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.BlockProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, login)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserImages provides a mock function with given fields: ctx, id, login
func (_m *Backend) GetUserImages(ctx context.Context, id string, login string) (*models.ImageProperties, error) {
	ret := _m.Called(ctx, id, login)

	var r0 *models.ImageProperties
	if rf, ok := ret.Get(0).(func(context.Context, string, string) *models.ImageProperties); ok {
		r0 = rf(ctx, id, login)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.ImageProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, id, login)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserPhoneNumber provides a mock function with given fields: ctx, id
func (_m *Backend) GetUserPhoneNumber(ctx context.Context, id string) (*models.PhoneNumberProperties, error) {
	ret := _m.Called(ctx, id)

	var r0 *models.PhoneNumberProperties
	if rf, ok := ret.Get(0).(func(context.Context, string) *models.PhoneNumberProperties); ok {
		r0 = rf(ctx, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.PhoneNumberProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserPropertiesBulk provides a mock function with given fields: ctx, params
func (_m *Backend) GetUserPropertiesBulk(ctx context.Context, params *models.FilterParams) ([]models.Properties, error) {
	ret := _m.Called(ctx, params)

	var r0 []models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, *models.FilterParams) []models.Properties); ok {
		r0 = rf(ctx, params)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *models.FilterParams) error); ok {
		r1 = rf(ctx, params)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserPropertiesByDisplayname provides a mock function with given fields: ctx, dn
func (_m *Backend) GetUserPropertiesByDisplayname(ctx context.Context, dn *string) (*models.Properties, error) {
	ret := _m.Called(ctx, dn)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, *string) *models.Properties); ok {
		r0 = rf(ctx, dn)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *string) error); ok {
		r1 = rf(ctx, dn)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserPropertiesByID provides a mock function with given fields: ctx, id, opts
func (_m *Backend) GetUserPropertiesByID(ctx context.Context, id string, opts util.ReadOptions) (*models.Properties, error) {
	ret := _m.Called(ctx, id, opts)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, util.ReadOptions) *models.Properties); ok {
		r0 = rf(ctx, id, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, util.ReadOptions) error); ok {
		r1 = rf(ctx, id, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserPropertiesByLogin provides a mock function with given fields: ctx, login, opts
func (_m *Backend) GetUserPropertiesByLogin(ctx context.Context, login string, opts util.ReadOptions) (*models.Properties, error) {
	ret := _m.Called(ctx, login, opts)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, util.ReadOptions) *models.Properties); ok {
		r0 = rf(ctx, login, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, util.ReadOptions) error); ok {
		r1 = rf(ctx, login, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserPropertiesLike provides a mock function with given fields: ctx, field, pattern
func (_m *Backend) GetUserPropertiesLike(ctx context.Context, field string, pattern string) ([]models.Properties, error) {
	ret := _m.Called(ctx, field, pattern)

	var r0 []models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, string) []models.Properties); ok {
		r0 = rf(ctx, field, pattern)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, field, pattern)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUsersProperties provides a mock function with given fields: ctx, field, identifiers
func (_m *Backend) GetUsersProperties(ctx context.Context, field string, identifiers []string) ([]models.Properties, error) {
	ret := _m.Called(ctx, field, identifiers)

	var r0 []models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, []string) []models.Properties); ok {
		r0 = rf(ctx, field, identifiers)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, []string) error); ok {
		r1 = rf(ctx, field, identifiers)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// HardDeleteUser provides a mock function with given fields: ctx, ID, skipBlock
func (_m *Backend) HardDeleteUser(ctx context.Context, ID string, skipBlock bool) (*models.Properties, error) {
	ret := _m.Called(ctx, ID, skipBlock)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, bool) *models.Properties); ok {
		r0 = rf(ctx, ID, skipBlock)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, bool) error); ok {
		r1 = rf(ctx, ID, skipBlock)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetUserImageProperties provides a mock function with given fields: ctx, updates
func (_m *Backend) SetUserImageProperties(ctx context.Context, updates models.ImageProperties) error {
	ret := _m.Called(ctx, updates)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.ImageProperties) error); ok {
		r0 = rf(ctx, updates)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SoftDeleteUser provides a mock function with given fields: ctx, ID
func (_m *Backend) SoftDeleteUser(ctx context.Context, ID string) error {
	ret := _m.Called(ctx, ID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, ID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UnbanUser provides a mock function with given fields: ctx, id, tosCount, dmcaCount
func (_m *Backend) UnbanUser(ctx context.Context, id string, tosCount int, dmcaCount int) error {
	ret := _m.Called(ctx, id, tosCount, dmcaCount)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, int, int) error); ok {
		r0 = rf(ctx, id, tosCount, dmcaCount)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UndeleteUser provides a mock function with given fields: ctx, ID
func (_m *Backend) UndeleteUser(ctx context.Context, ID string) error {
	ret := _m.Called(ctx, ID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, ID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateProperties provides a mock function with given fields: ctx, uup, cup
func (_m *Backend) UpdateProperties(ctx context.Context, uup *models.UpdateableProperties, cup *models.Properties) error {
	ret := _m.Called(ctx, uup, cup)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *models.UpdateableProperties, *models.Properties) error); ok {
		r0 = rf(ctx, uup, cup)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// VerifyUserPhoneNumber provides a mock function with given fields: ctx, id
func (_m *Backend) VerifyUserPhoneNumber(ctx context.Context, id string) error {
	ret := _m.Called(ctx, id)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
