package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"
import users "code.justin.tv/web/users-service/backend/users"

// CacheBackend is an autogenerated mock type for the CacheBackend type
type CacheBackend struct {
	mock.Mock
}

// CacheUsersProperties provides a mock function with given fields: ctx, props, overwrite
func (_m *CacheBackend) CacheUsersProperties(ctx context.Context, props []models.Properties, overwrite bool) error {
	ret := _m.Called(ctx, props, overwrite)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []models.Properties, bool) error); ok {
		r0 = rf(ctx, props, overwrite)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ExpireUserProperties provides a mock function with given fields: ctx, prop
func (_m *CacheBackend) ExpireUserProperties(ctx context.Context, prop *models.Properties) error {
	ret := _m.Called(ctx, prop)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *models.Properties) error); ok {
		r0 = rf(ctx, prop)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetUserProperties provides a mock function with given fields: ctx, field, key
func (_m *CacheBackend) GetUserProperties(ctx context.Context, field string, key string) (*models.Properties, error) {
	ret := _m.Called(ctx, field, key)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, string) *models.Properties); ok {
		r0 = rf(ctx, field, key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, field, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUsersProperties provides a mock function with given fields: ctx, field, identifiers
func (_m *CacheBackend) GetUsersProperties(ctx context.Context, field string, identifiers []string) ([]models.Properties, []int, error) {
	ret := _m.Called(ctx, field, identifiers)

	var r0 []models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, []string) []models.Properties); ok {
		r0 = rf(ctx, field, identifiers)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]models.Properties)
		}
	}

	var r1 []int
	if rf, ok := ret.Get(1).(func(context.Context, string, []string) []int); ok {
		r1 = rf(ctx, field, identifiers)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]int)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string, []string) error); ok {
		r2 = rf(ctx, field, identifiers)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

var _ users.CacheBackend = (*CacheBackend)(nil)
