package util

import (
	"net/http"

	"code.justin.tv/web/users-service/models"
)

type ReadOptions struct {
	ReadFromMaster bool
	OverwriteCache bool
}

type Fieldidentifier struct {
	Field string
	Ids   []string
}

// ErrNoProperties indicates that there are no properties for the channel name given
var ErrNoProperties = &models.CodedError{
	CodeValue:       "no_properties",
	ErrorValue:      "No properties found for this user identifier",
	StatusCodeValue: http.StatusNotFound,
	SkipCircuitTrip: true,
}

const DBError = "db_error"
