FROM docker-registry.internal.justin.tv/devtools/xenial/go1.8.4:latest

WORKDIR /go/src/code.justin.tv/web/users-service

RUN apt-get update && apt-get install -y wget pkg-config libgeoip-dev git && \
    echo 'deb http://apt.postgresql.org/pub/repos/apt/ precise-pgdg main' > /etc/apt/sources.list.d/pgdg.list && \
    wget --quiet -O - https://www.postgresql.org/media/keys/ACCC4CF8.asc | apt-key add - && \
    apt-get update && apt-get -y install postgresql-9.4 postgresql-contrib-9.4 && \
    curl -s http://download.redis.io/releases/redis-2.8.12.tar.gz | tar xz && \
    make install -C redis-2.8.12 > /dev/null && \
    go get github.com/kisielk/errcheck && \
    go get github.com/golang/lint/golint && \
    go get github.com/jstemmer/go-junit-report && \
    wget -N http://geolite.maxmind.com/download/geoip/database/GeoLiteCountry/GeoIP.dat.gz && \
    gunzip GeoIP.dat.gz && \
    mkdir -p /usr/local/share/GeoIP/ && \
    mv GeoIP.dat /usr/local/share/GeoIP/

ENV PGDATA=/var/lib/pgsql/data
ENV PATH=/go/bin/:/usr/local/go/bin:$PATH
ENV GOPATH=/go

ENV ENVIRONMENT=test
# needed for kinesis publisher to configure.
# in prod this is either handled by the instance role or STSAssumeRole
ENV AWS_ACCESS_KEY_ID='garbage'
ENV AWS_SECRET_ACCESS_KEY='moargarbage'

CMD make test
