#!/bin/bash
set -e

function cleanup() {
    # kill background jobs, like logs
    kill $(jobs -p) || echo "no background jobs to delete"

    # stop containers and remove them
    docker-compose stop
    docker-compose rm -f

    # exit with original error
    exit $1
}

trap cleanup EXIT

# build our compose images
docker-compose build

docker-compose up -d db

sleep 5

docker-compose up -d redis snssqs

# Run logs in the background
docker-compose logs -f &

# Give database time to start
sleep 5

docker-compose up -d server worker

# Sleep to allow users-service to spin up and connect. Probably want to improve this mechanism somehow
sleep 10

echo "==> verifying applications are up"
curl -v 127.0.0.1:8000/debug/running || (echo "server isn't running" && exit 1)
curl -v 127.0.0.1:8001/debug/running || (echo "worker isn't running" && exit 1)
echo "<== verified applications are up"

echo "==> running integration tests"
docker-compose -f docker-compose.test.yml -f docker-compose.yml run --rm integtest
echo "<== ran integration tests"
