package mocks

import context "context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"
import twitchclient "code.justin.tv/foundation/twitchclient"
import usersclient_external "code.justin.tv/web/users-service/client/usersclient_external"

// ExternalClient is an autogenerated mock type for the ExternalClient type
type ExternalClient struct {
	mock.Mock
}

// GetRenameEligibility provides a mock function with given fields: ctx, userID, reqOpts
func (_m *ExternalClient) GetRenameEligibility(ctx context.Context, userID string, reqOpts *twitchclient.ReqOpts) (*models.RenameProperties, error) {
	ret := _m.Called(ctx, userID, reqOpts)

	var r0 *models.RenameProperties
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) *models.RenameProperties); ok {
		r0 = rf(ctx, userID, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.RenameProperties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, userID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserByID provides a mock function with given fields: ctx, userID, requester, reqOpts
func (_m *ExternalClient) GetUserByID(ctx context.Context, userID string, requester string, reqOpts *twitchclient.ReqOpts) (*models.Properties, error) {
	ret := _m.Called(ctx, userID, requester, reqOpts)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchclient.ReqOpts) *models.Properties); ok {
		r0 = rf(ctx, userID, requester, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, userID, requester, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserByIDAndParams provides a mock function with given fields: ctx, userID, requester, params, reqOpts
func (_m *ExternalClient) GetUserByIDAndParams(ctx context.Context, userID string, requester string, params *models.FilterParams, reqOpts *twitchclient.ReqOpts) (*models.Properties, error) {
	ret := _m.Called(ctx, userID, requester, params, reqOpts)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *models.FilterParams, *twitchclient.ReqOpts) *models.Properties); ok {
		r0 = rf(ctx, userID, requester, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, *models.FilterParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, userID, requester, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserByLogin provides a mock function with given fields: ctx, login, requester, reqOpts
func (_m *ExternalClient) GetUserByLogin(ctx context.Context, login string, requester string, reqOpts *twitchclient.ReqOpts) (*models.Properties, error) {
	ret := _m.Called(ctx, login, requester, reqOpts)

	var r0 *models.Properties
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchclient.ReqOpts) *models.Properties); ok {
		r0 = rf(ctx, login, requester, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Properties)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, login, requester, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUsers provides a mock function with given fields: ctx, requester, params, reqOpts
func (_m *ExternalClient) GetUsers(ctx context.Context, requester string, params *models.FilterParams, reqOpts *twitchclient.ReqOpts) (*models.PropertiesResult, error) {
	ret := _m.Called(ctx, requester, params, reqOpts)

	var r0 *models.PropertiesResult
	if rf, ok := ret.Get(0).(func(context.Context, string, *models.FilterParams, *twitchclient.ReqOpts) *models.PropertiesResult); ok {
		r0 = rf(ctx, requester, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.PropertiesResult)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *models.FilterParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, requester, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUsersByLoginLike provides a mock function with given fields: ctx, requester, pattern, reqOpts
func (_m *ExternalClient) GetUsersByLoginLike(ctx context.Context, requester string, pattern string, reqOpts *twitchclient.ReqOpts) (*models.PropertiesResult, error) {
	ret := _m.Called(ctx, requester, pattern, reqOpts)

	var r0 *models.PropertiesResult
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchclient.ReqOpts) *models.PropertiesResult); ok {
		r0 = rf(ctx, requester, pattern, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.PropertiesResult)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, requester, pattern, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetUser provides a mock function with given fields: ctx, userID, uup, reqOpts
func (_m *ExternalClient) SetUser(ctx context.Context, userID string, uup *models.UpdateableProperties, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, userID, uup, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *models.UpdateableProperties, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, userID, uup, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetUserImageMetadata provides a mock function with given fields: ctx, uup, reqOpts
func (_m *ExternalClient) SetUserImageMetadata(ctx context.Context, uup models.ImageProperties, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, uup, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.ImageProperties, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, uup, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetUserImageMetadataAuthed provides a mock function with given fields: ctx, string, uup, reqOpts
func (_m *ExternalClient) SetUserImageMetadataAuthed(ctx context.Context, editor string, uup models.ImageProperties, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, uup, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, models.ImageProperties, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, editor, uup, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UploadUserImage provides a mock function with given fields: ctx, userID, uup, reqOpts
func (_m *ExternalClient) UploadUserImage(ctx context.Context, userID string, uup models.UploadableImage, reqOpts *twitchclient.ReqOpts) (*models.UploadInfo, error) {
	ret := _m.Called(ctx, userID, uup, reqOpts)

	var r0 *models.UploadInfo
	if rf, ok := ret.Get(0).(func(context.Context, string, models.UploadableImage, *twitchclient.ReqOpts) *models.UploadInfo); ok {
		r0 = rf(ctx, userID, uup, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.UploadInfo)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, models.UploadableImage, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, userID, uup, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// VerifyUserPhoneNumber provides a mock function with given fields: ctx, userID, code, reqOpts
func (_m *ExternalClient) VerifyUserPhoneNumber(ctx context.Context, userID string, code string, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, userID, code, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, userID, code, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ usersclient_external.ExternalClient = (*ExternalClient)(nil)
