package configs

import (
	"testing"
)

func TestEnvironmentNameFromString(t *testing.T) {
	for name, expected := range map[string]string{
		"CacheBackend": "CACHE_BACKEND",
		"RedisTTL":     "REDIS_TTL",
	} {
		t.Run(name, func(t *testing.T) {
			actual := environmentNameFromString(name)
			if actual != expected {
				t.Errorf("expected %q, got %q", expected, actual)
			}
		})
	}
}

func TestEnvironmentNameFromType(t *testing.T) {
	for name, expected := range map[string]string{
		"CacheBackend": "CACHE_BACKEND",
		"RedisTTL":     "REDIS_TTL",
	} {
		t.Run(name, func(t *testing.T) {
			actual := environmentNameFromString(name)
			if actual != expected {
				t.Errorf("expected %q, got %q", expected, actual)
			}
		})
	}
}

type testStruct struct {
	A string
	C int
}

func TestReflectTypeValueError(t *testing.T) {
	var s testStruct
	_, _, err := ReflectTypeValue(s)
	if err == nil {
		t.Fatal("expected error, interface is not a pointer")
	}
}
