package configs

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
)

const (
	oldStagingAccountNumber = "465369119046"
	oldProdAccountNumber    = "641044725657"
)

var Defined = MultiConfig{
	SiteDB: MultiDB{
		Name: EnvString{
			Default: "users_service_justintv_dev",
			Production: &RegionString{
				Default: aws.String("users_service_justintv_prod"),
			},
			Test: &RegionString{
				Default: aws.String("users"),
			},
		},
		User: EnvString{
			Default: "users_service_01",
			Test: &RegionString{
				Default: aws.String("users"),
			},
		},
		PasswordFile: EnvString{
			Default: ".dbpass_dev",
		},
		Password: EnvString{
			Test: &RegionString{
				Default: aws.String("users"),
			},
		},
		Master: MultiDBHost{
			Host: EnvString{
				Default: "localhost",
				Development: &RegionString{
					Default: aws.String("master-sitedb.staging.us-west2.justin.tv"),
				},
				Staging: &RegionString{
					Default: aws.String("master-sitedb.staging.us-west2.justin.tv"),
				},
				Production: &RegionString{
					Default: aws.String("rails-pgbouncer-internal.prod.us-west2.justin.tv"),
				},
				Test: &RegionString{
					Default: aws.String("db"),
				},
			},
			Port: EnvInt{
				Default: 5432,
				Development: &RegionInt{
					Default: aws.Int(6542),
				},
				Staging: &RegionInt{
					Default: aws.Int(6542),
				},
				Production: &RegionInt{
					Default: aws.Int(12005),
				},
			},
			MaxOpenConns:       EnvInt{Default: 100},
			MaxIdleConns:       EnvInt{Default: 100},
			MaxQueueSize:       EnvInt{Default: 100},
			ConnAcquireTimeout: EnvDuration{Default: 1 * time.Second},
			RequestTimeout:     EnvDuration{Default: 5 * time.Second},
			MaxConnAge:         EnvDuration{Default: 60 * time.Second},
			LoggerPrefix: EnvString{
				Default: "masterdb.",
			},
		},
		Slave: MultiDBHost{
			Host: EnvString{
				Default: "localhost",
				Development: &RegionString{
					Default: aws.String("replica-sitedb.staging.us-west2.justin.tv"),
				},
				Staging: &RegionString{
					Default: aws.String("replica-sitedb.staging.us-west2.justin.tv"),
				},
				Production: &RegionString{
					Default: aws.String("sitedb-replica-internal.prod.us-west2.justin.tv"),
				},
				Test: &RegionString{
					Default: aws.String("db"),
				},
			},
			Port: EnvInt{
				Default: 5432,
				Development: &RegionInt{
					Default: aws.Int(6542),
				},
				Staging: &RegionInt{
					Default: aws.Int(6542),
				},
				Production: &RegionInt{
					Default: aws.Int(12006),
				},
			},
			MaxOpenConns:       EnvInt{Default: 100},
			MaxIdleConns:       EnvInt{Default: 100},
			MaxQueueSize:       EnvInt{Default: 100},
			ConnAcquireTimeout: EnvDuration{Default: 1 * time.Second},
			RequestTimeout:     EnvDuration{Default: 5 * time.Second},
			MaxConnAge:         EnvDuration{Default: 60 * time.Second},
			LoggerPrefix: EnvString{
				Default: "slavedb.",
			},
		},
	},

	Reservations: MultiDB{
		Name: EnvString{
			Default: "users_service_dev",
			Production: &RegionString{
				Default: aws.String("users_service_prod"),
			},
			Test: &RegionString{
				Default: aws.String("users"),
			},
		},
		User: EnvString{
			Default: "users_service_01",
			Test: &RegionString{
				Default: aws.String("users"),
			},
		},
		Password: EnvString{
			Development: &RegionString{
				Default: aws.String("######"),
			},
			Test: &RegionString{
				Default: aws.String("users"),
			},
		},
		Master: MultiDBHost{
			Host: EnvString{
				Default: "localhost",
				Development: &RegionString{
					Default: aws.String("master-users-db.staging.us-west2.justin.tv"),
				},

				Staging: &RegionString{
					Default: aws.String("master-users-db.staging.us-west2.justin.tv"),
				},
				Production: &RegionString{
					Default: aws.String("master-users-db.production.us-west2.justin.tv"),
				},
				Test: &RegionString{
					Default: aws.String("db"),
				},
			},
			Port: EnvInt{
				Default: 5432,
				Development: &RegionInt{
					Default: aws.Int(5433),
				},
				Production: &RegionInt{
					Default: aws.Int(12015),
				},
				Staging: &RegionInt{
					Default: aws.Int(5433),
				},
			},
			MaxOpenConns:       EnvInt{Default: 100},
			MaxIdleConns:       EnvInt{Default: 100},
			MaxQueueSize:       EnvInt{Default: 100},
			ConnAcquireTimeout: EnvDuration{Default: 1 * time.Second},
			RequestTimeout:     EnvDuration{Default: 5 * time.Second},
			MaxConnAge:         EnvDuration{Default: 60 * time.Second},
			LoggerPrefix: EnvString{
				Default: "masterdb.",
			},
		},
		Slave: MultiDBHost{
			Host: EnvString{
				Default: "localhost",
				Development: &RegionString{
					Default: aws.String("replica-users-db.staging.us-west2.justin.tv"),
				},
				Staging: &RegionString{
					Default: aws.String("replica-users-db.staging.us-west2.justin.tv"),
				},
				Production: &RegionString{
					Default: aws.String("replica-users-db.production.us-west2.justin.tv"),
				},
				Test: &RegionString{
					Default: aws.String("db"),
				},
			},
			Port: EnvInt{
				Default: 5432,
				Development: &RegionInt{
					Default: aws.Int(5434),
				},
				Production: &RegionInt{
					Default: aws.Int(12016),
				},
				Staging: &RegionInt{
					Default: aws.Int(5434),
				},
			},
			MaxOpenConns:       EnvInt{Default: 100},
			MaxIdleConns:       EnvInt{Default: 100},
			MaxQueueSize:       EnvInt{Default: 100},
			ConnAcquireTimeout: EnvDuration{Default: 1 * time.Second},
			RequestTimeout:     EnvDuration{Default: 5 * time.Second},
			MaxConnAge:         EnvDuration{Default: 60 * time.Second},
			LoggerPrefix: EnvString{
				Default: "slavedb.",
			},
		},
	},

	Hosts: MultiHosts{
		Rails: EnvString{
			Default: "staging-ffa-36-01d094c6-app.dev.us-west2.justin.tv:7000",
			Production: &RegionString{
				Default: aws.String("api.internal.twitch.tv"),
			},
		},
		Follows: EnvString{
			Default: "internal-following-service-staging-app-2022864404.us-west-2.elb.amazonaws.com",
			Production: &RegionString{
				Default: aws.String("internal-following-service-production-app-772191406.us-west-2.elb.amazonaws.com"),
			},
		},
		Discovery: EnvString{
			Default: "http://discovery-staging.dev.us-west2.twitch.tv:9292",
			Production: &RegionString{
				Default: aws.String("http://discovery-production.prod.us-west2.twitch.tv:9292"),
			},
		},
		EVS: EnvString{
			Default: "http://emailvalidator.stage.us-west2.twitch.tv",
			Production: &RegionString{
				Default: aws.String("http://emailvalidator.prod.us-west2.twitch.tv"),
			},
		},
		UploadService: EnvString{
			Default: "http://staging-web-upload-service.staging.us-west2.twitch.tv",
			Production: &RegionString{
				Default: aws.String("http://prod-web-upload-service.prod.us-west2.twitch.tv"),
			},
		},
		Owl: EnvString{
			Default: "http://owl.dev.us-west2.justin.tv",
			Production: &RegionString{
				Default: aws.String("http://owl.prod.us-west2.justin.tv"),
			},
		},
		PubSub: EnvString{
			Default: "http://pubsub-broker-darklaunch.internal.twitch.tv",
			Production: &RegionString{
				Default: aws.String("http://pubsub-broker.internal.twitch.tv"),
			},
		},
		Partnerships: EnvString{
			Default: "https://moneypenny.dev.us-west2.internal.justin.tv",
			Production: &RegionString{
				Default: aws.String("https://moneypenny.internal.justin.tv"),
			},
		},
		Spade: EnvString{
			Default: "spade.internal.justin.tv",
		},
		Auditor: EnvString{
			Default: "http://history.staging.us-west2.twitch.tv",
			Production: &RegionString{
				Default: aws.String("http://history.prod.us-west2.twitch.tv"),
			},
		},
	},
	Cache: MultiCache{
		Backup: MultiRedis{
			Host: EnvString{
				Default: "localhost:14912",
				Development: &RegionString{
					Default: aws.String("users-service-aws-088b1629ecfc19bb5.dev.us-west2.justin.tv:14912"),
				},
				Staging: &RegionString{
					Default: aws.String("redis-14912.us-west-mz.4.redislabs.twitch.tv:14912"),
					USEast1: aws.String("us-backup-cache.zgbftt.clustercfg.use1.cache.amazonaws.com:6379"),
				},
				Production: &RegionString{
					Default: aws.String("redis-17850.internal.c8.us-west-2-mz.ec2.cloud.redislabs.com:17850"),
					USEast1: aws.String("us-backup-cache.b8agcy.clustercfg.use1.cache.amazonaws.com:6379"),
				},
				Test: &RegionString{
					Default: aws.String("redis:6379"),
				},
			},
			UseClusterMode: EnvBool{
				Default: false,
				Staging: &RegionBool{
					USEast1: aws.Bool(true),
				},
				Production: &RegionBool{
					USEast1: aws.Bool(true),
				},
			},
			ConnectTimeout: EnvInt{
				Default: 300,
				Development: &RegionInt{
					Default: aws.Int(500),
				},
			},
			ReadTimeout: EnvInt{
				Default: 300,
			},
			WriteTimeout: EnvInt{
				Default: 500,
			},
			MaxConnections: EnvInt{
				Default: 1000,
			},
			Password: EnvString{
				Development: &RegionString{
					Default: aws.String("######"),
				},
			},
		},
		Primary: MultiRedis{
			Host: EnvString{
				Default: "localhost:14912",
				Development: &RegionString{
					Default: aws.String("users-service-cache.qg4ybk.clustercfg.usw2.cache.amazonaws.com:6379"),
				},
				Staging: &RegionString{
					Default: aws.String("users-service-cache.qg4ybk.clustercfg.usw2.cache.amazonaws.com:6379"),
					USEast1: aws.String("us-primary-cache.zgbftt.clustercfg.use1.cache.amazonaws.com:6379"),
				},
				Production: &RegionString{
					Default: aws.String("users-srvc-cache.uddqnd.clustercfg.usw2.cache.amazonaws.com:6379"),
					USEast1: aws.String("us-primary-cache.b8agcy.clustercfg.use1.cache.amazonaws.com:6379"),
				},
				Test: &RegionString{
					Default: aws.String("redis:6379"),
				},
			},
			UseClusterMode: EnvBool{
				Default: true,
			},
			ConnectTimeout: EnvInt{
				Default: 300,
				Development: &RegionInt{
					Default: aws.Int(500),
				},
			},
			ReadTimeout: EnvInt{
				Default: 300,
			},
			WriteTimeout: EnvInt{
				Default: 500,
			},
			MaxConnections: EnvInt{
				Default: 1000,
			},
		},
	},
	RedisTTL: EnvInt{
		Default: 21600000,
		Development: &RegionInt{
			Default: aws.Int(30000),
		},
	},
	UserMutations: MultiKinesisStream{
		Role: EnvString{
			Default: "arn:aws:iam::465369119046:role/user-mutations-stream-role",
			Production: &RegionString{
				Default: aws.String("arn:aws:iam::641044725657:role/user-mutations-stream-role"),
			},
		},
		Name: EnvString{
			Default: "user-mutations-stream",
		},
		Region: EnvString{
			Default: "us-west-2",
		},
		RetryCount: EnvInt{
			Default: 10,
		},
		RetryDelay: EnvInt{
			Default: 100,
		},
	},
	Topics: MultiTopics{
		SNSRegions: EnvString{
			Default: "us-west-2,us-east-1",
		},
		ModerationEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:user_moderation_events",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:user_moderation_events"),
			},
		},
		RenameEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:user_rename_events",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:user_rename_events"),
			},
		},
		CreationEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:notification-user-created",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:notification-user-created"),
			},
		},
		MutationEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:user_mutation_events",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:user_mutation_events"),
			},
		},
		ImageUploadEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:user_image_upload_events",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:user_image_upload_events"),
			},
		},
		ChannelMutationEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:channel_mutation_events",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:channel_mutation_events"),
			},
		},
		EmailVerified: EnvString{
			Default: "arn:aws:sns:us-west-2:510557735000:email-validation-success",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:523543649671:email-validation-success"),
			},
		},
		PushyDispatched: EnvString{
			Default: "arn:aws:sns:us-west-2:603200399373:pushy_darklaunch_dispatch",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:603200399373:pushy_production_dispatch"),
			},
		},
		UserSoftDeleteEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:user_soft_delete_events",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:user_soft_delete_events"),
			},
		},
		UserUndeleteEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:user_undelete_events",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:user_undelete_events"),
			},
		},
		UserHardDeleteEvents: EnvString{
			Default: "arn:aws:sns:us-west-2:465369119046:notification-user-destroyed",
			Production: &RegionString{
				Default: aws.String("arn:aws:sns:us-west-2:641044725657:notification-user-destroyed"),
			},
		},
		ExpireCacheEvents: EnvString{
			Default: "arn:aws:sns:us-east-1:404788901388:cache_expiration_events",
			Production: &RegionString{
				USEast1: aws.String("arn:aws:sns:us-west-2:641044725657:cache_expiration_events"),
				USWest2: aws.String("arn:aws:sns:us-east-1:931896176507:cache_expiration_events"),
			},
		},
	},
	Leviathan: MultiLeviathan{
		Host: EnvString{
			Default: "DUMMY_HOST",
			Production: &RegionString{
				Default: aws.String("https://leviathan.internal.twitch.tv:443"),
			},
		},
		Token: EnvString{
			Default: "DUMMY_TOKEN",
		},
	},
	XraySampling: EnvFloat64{
		Default: -1,
	},
	Twilio: MultiTwilio{
		Disabled: EnvBool{
			Default: false,
			Development: &RegionBool{
				Default: aws.Bool(true),
			},
			Test: &RegionBool{
				Default: aws.Bool(true),
			},
		},
	},
	GeoIPPath: EnvString{
		Default: "/usr/share/GeoIP/GeoIP.dat",
	},
	CartmanKeyPath: EnvString{
		Default: "./configs/cartman_dev_key",
	},
	SQSRegion: EnvString{
		Default: "us-west-2",
		Test: &RegionString{
			Default: aws.String("local"),
		},
		Staging: &RegionString{
			USEast1: aws.String("us-east-1"),
		},
		Production: &RegionString{
			USEast1: aws.String("us-east-1"),
		},
	},
	SQSEndpoint: EnvString{
		Test: &RegionString{
			Default: aws.String("http://snssqs:4100"),
		},
	},
	Workers: MultiWorkerQueues{
		EmailVerified: MultiWorkerQueue{
			LogEventName: EnvString{Default: "emailvalidationsuccess"},
			NumWorkers: EnvInt{
				Default: 2,
			},
			QueueName: EnvString{
				Default: "email-verified",
			},
			AccountNumber: EnvString{
				Staging: &RegionString{
					USWest2: aws.String(oldStagingAccountNumber),
				},
				Production: &RegionString{
					USWest2: aws.String(oldProdAccountNumber),
				},
			},
			Disabled: EnvBool{
				Staging: &RegionBool{
					USEast1: aws.Bool(true),
				},
				Production: &RegionBool{
					USEast1: aws.Bool(true),
				},
			},
			MaxVisibilityTimeout: EnvInt{
				Default: 30,
			},
		},
		ImageUpload: MultiWorkerQueue{
			LogEventName: EnvString{Default: "imageuploadsuccess"},
			NumWorkers: EnvInt{
				Default: 2,
			},
			QueueName: EnvString{
				Default: "image-upload-staging",
				Production: &RegionString{
					Default: aws.String("image-upload-production"),
				},
			},
			AccountNumber: EnvString{
				Staging: &RegionString{
					USWest2: aws.String(oldStagingAccountNumber),
				},
				Production: &RegionString{
					USWest2: aws.String(oldProdAccountNumber),
				},
			},
			Disabled: EnvBool{
				Staging: &RegionBool{
					USEast1: aws.Bool(true),
					USWest2: aws.Bool(true),
				},
				Production: &RegionBool{
					USEast1: aws.Bool(true),
				},
			},
			MaxVisibilityTimeout: EnvInt{
				Default: 30,
			},
		},
		ExpireCache: MultiWorkerQueue{
			LogEventName: EnvString{Default: "expirecachequeue"},
			NumWorkers: EnvInt{
				Default: 2,
			},
			QueueName: EnvString{
				Default: "expire-cache",
			},
			AccountNumber: EnvString{
				Staging: &RegionString{
					USWest2: aws.String(oldStagingAccountNumber),
				},
				Production: &RegionString{
					USWest2: aws.String(oldProdAccountNumber),
				},
			},
			Disabled: EnvBool{},
			MaxVisibilityTimeout: EnvInt{
				Default: 30,
			},
		},
		DeadLetter: MultiWorkerQueue{
			LogEventName: EnvString{Default: "deadletterqueue"},
			NumWorkers: EnvInt{
				Default: 1,
			},
			QueueName: EnvString{
				Default: "users-service-dead-letter-queue-staging",
				Production: &RegionString{
					Default: aws.String("users-service-dead-letter-queue-production"),
				},
			},
			AccountNumber: EnvString{
				Staging: &RegionString{
					USWest2: aws.String(oldStagingAccountNumber),
				},
				Production: &RegionString{
					USWest2: aws.String(oldProdAccountNumber),
				},
			},
			Disabled: EnvBool{},
			MaxVisibilityTimeout: EnvInt{
				Default: 30,
			},
		},
	},
	NoopRailsClient: EnvBool{
		Default: false,
		Test: &RegionBool{
			Default: aws.Bool(true),
		},
	},
	STSAssumeRole: EnvString{
		Staging: &RegionString{
			// Note: this value is only valid for the new account, aka not beanstalk
			USWest2: aws.String("arn:aws:iam::465369119046:role/users-service"),
		},
		Production: &RegionString{
			// Note: this value is only valid for the new account, aka not beanstalk
			USWest2: aws.String("arn:aws:iam::641044725657:role/users-service"),
		},
	},
	Stats: MultiStats{
		App: EnvString{
			Default: "users-service",
		},
		HostPort: EnvString{
			Default: "statsd.internal.justin.tv:8125",
		},
	},
	HystrixSampling: EnvFloat32{
		Default: 1,
		Production: &RegionFloat32{
			Default: ptrFloat32(0.01),
		},
	},
	HystrixErrorSampling: EnvFloat32{
		Default: 1,
	},

	// Test only below here
	LegacyAWSKey: EnvString{
		Test: &RegionString{
			Default: aws.String("garbage"),
		},
	},
	LegacyAWSSecret: EnvString{
		Test: &RegionString{
			Default: aws.String("moargarbage"),
		},
	},
	RollbarToken: EnvString{
		Test: &RegionString{
			Default: aws.String("b275148ce7bf4ebc86b3c4c2ca8a3ec3"),
		},
	},
	SeedVerifyCode: EnvString{
		Test: &RegionString{
			Default: aws.String("123123"),
		},
	},
}

func ptrFloat32(n float32) *float32 {
	return &n
}
