package configs

import (
	"reflect"
	"testing"
)

func TestEnvRegionSandstormConfig(t *testing.T) {
	type args struct {
		env     string
		region  string
		configs []SandstormConfig
	}
	tests := []struct {
		name    string
		args    args
		want    *SandstormConfig
		wantErr bool
	}{
		{
			name:    "found config",
			wantErr: false,
			want: &SandstormConfig{
				Environment: "staging",
				Region:      "us-west-2",
				Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-staging",
			},
			args: args{
				env:    "staging",
				region: "us-west-2",
				configs: []SandstormConfig{
					{
						Environment: "staging",
						Region:      "us-west-2",
						Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-staging",
					}, {
						Environment: "production",
						Region:      "us-west-2",
						Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-production",
					},
				},
			},
		},
		{
			name:    "not config",
			wantErr: true,
			args: args{
				env:    "staging",
				region: "us-east-1",
				configs: []SandstormConfig{
					{
						Environment: "staging",
						Region:      "us-west-2",
						Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-staging",
					}, {
						Environment: "production",
						Region:      "us-west-2",
						Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-production",
					},
				},
			},
		},
		{
			name: "us-east-1",
			want: &SandstormConfig{

				Environment: "staging",
				Region:      "us-east-1",
				Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-staging",
			},
			args: args{
				env:    "staging",
				region: "us-east-1",
				configs: []SandstormConfig{
					{
						Environment: "staging",
						Region:      "us-east-1",
						Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-staging",
					}, {
						Environment: "production",
						Region:      "us-west-2",
						Role:        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-users-service-production",
					},
				},
			},
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := EnvRegionSandstormConfig(tt.args.env, tt.args.region, tt.args.configs)
			if (err != nil) != tt.wantErr {
				t.Errorf("EnvRegionSandstormConfig() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("EnvRegionSandstormConfig() = %v, want %v", got, tt.want)
			}
		})
	}
}
