package configs

import (
	"testing"
)

type testSecret struct {
	// non settable
	_ struct{}

	Nothing    string
	Secret     string `secret:"secret"`
	SecretFile string `secret_file:"secret_file"`
	Nested     testSecretNested
}

type testSecretNested struct {
	Nothing    string
	Secret     string `secret:"secret"`
	SecretFile string `secret_file:"secret_file"`
}

func TestLoadSecrets(t *testing.T) {
	ts := &testSecret{}

	m := &MockSecretGetter{}
	expectedSecret := "A"
	expectedSecretFile := "B"
	m.On("Get", "secret").Return(expectedSecret, nil)
	m.On("Get", "secret_file").Return(expectedSecretFile, nil)

	files, err := LoadSecrets(ts, m)
	if err != nil {
		t.Fatal(err)
	}

	if ts.Secret != expectedSecret {
		t.Errorf("expected %q, got %q", expectedSecret, ts.Secret)
	}

	if ts.SecretFile == "" {
		t.Errorf("expected secret file to be not empty")
	}

	if ts.Nested.Secret != expectedSecret {
		t.Errorf("expected %q, got %q", expectedSecret, ts.Nested.Secret)
	}

	if ts.Nested.SecretFile == "" {
		t.Errorf("expected secret file to be not empty")
	}

	if len(files) != 2 {
		t.Errorf("expected 2 files, got %d", len(files))
	}

	if err := files.Close(); err != nil {
		t.Fatal(err)
	}
}

type testSecretMap struct {
	A testSecretMapNested
	B testSecretMapNested
}

type testSecretMapNested struct {
	Value string `secret:"a:asdf,b:fdsa"`
}

func TestLoadSecretsMap(t *testing.T) {
	ts := &testSecretMap{}

	m := &MockSecretGetter{}
	expectedSecretA := "A"
	expectedSecretB := "B"
	m.On("Get", "asdf").Return(expectedSecretA, nil)
	m.On("Get", "fdsa").Return(expectedSecretB, nil)

	files, err := LoadSecrets(ts, m)
	if err != nil {
		t.Fatal(err)
	}

	if ts.A.Value != expectedSecretA {
		t.Errorf("expected %q, got %q", expectedSecretA, ts.A.Value)
	}

	if ts.B.Value != expectedSecretB {
		t.Errorf("expected %q, got %q", expectedSecretB, ts.B.Value)
	}

	if len(files) != 0 {
		t.Errorf("expected 0 files, got %d", len(files))
	}

	if err := files.Close(); err != nil {
		t.Fatal(err)
	}
}

type testSecretMapError struct {
	C testSecretMapNested
}
