#!/bin/bash

set -eo pipefail

# Collect packages in this repository
PKGS=$(go list ./...)

# Speed up test runs
go install ./...

function clean_up {
  rm *.cover.out
  exit $1
}

# Remove temporary cover files on exit
trap clean_up 0 1

for pkg in $PKGS; do
  # Ensure package name is filename friendly
  pkg_path=${pkg//\//-}
  # Run test coverage
  go test -coverprofile=${pkg_path}.cover.out ${pkg} -v | tee -a test.xml
done

# Compile test coverage files into one file
echo "mode: set" > coverage.out && cat *.cover.out | grep -v mode: | sort -r | \
awk '{if($1 != last) {print $0;last=$1}}' >> coverage.out

# Create junit compatible test results
cat test.xml | go-junit-report > test_report.xml
