package mocks

import context "golang.org/x/net/context"
import database "code.justin.tv/web/users-service/database"
import db "code.justin.tv/chat/db"
import mock "github.com/stretchr/testify/mock"

// Querier is an autogenerated mock type for the Querier type
type Querier struct {
	mock.Mock
}

// Begin provides a mock function with given fields: ctx, name
func (_m *Querier) Begin(ctx context.Context, name string) (db.Tx, error) {
	ret := _m.Called(ctx, name)

	var r0 db.Tx
	if rf, ok := ret.Get(0).(func(context.Context, string) db.Tx); ok {
		r0 = rf(ctx, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(db.Tx)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Exec provides a mock function with given fields: ctx, name, query, args
func (_m *Querier) Exec(ctx context.Context, name string, query string, args ...interface{}) (db.Result, error) {
	ret := _m.Called(ctx, name, query, args)

	var r0 db.Result
	if rf, ok := ret.Get(0).(func(context.Context, string, string, ...interface{}) db.Result); ok {
		r0 = rf(ctx, name, query, args...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(db.Result)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, ...interface{}) error); ok {
		r1 = rf(ctx, name, query, args...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Query provides a mock function with given fields: ctx, name, query, args
func (_m *Querier) Query(ctx context.Context, name string, query string, args ...interface{}) (database.Rows, error) {
	ret := _m.Called(ctx, name, query, args)

	var r0 database.Rows
	if rf, ok := ret.Get(0).(func(context.Context, string, string, ...interface{}) database.Rows); ok {
		r0 = rf(ctx, name, query, args...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(database.Rows)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, ...interface{}) error); ok {
		r1 = rf(ctx, name, query, args...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// QueryRow provides a mock function with given fields: ctx, name, query, args
func (_m *Querier) QueryRow(ctx context.Context, name string, query string, args ...interface{}) database.Row {
	ret := _m.Called(ctx, name, query, args)

	var r0 database.Row
	if rf, ok := ret.Get(0).(func(context.Context, string, string, ...interface{}) database.Row); ok {
		r0 = rf(ctx, name, query, args...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(database.Row)
		}
	}

	return r0
}

var _ database.Querier = (*Querier)(nil)
