package mocks

import context "golang.org/x/net/context"
import database "code.justin.tv/web/users-service/database"
import db "code.justin.tv/chat/db"
import mock "github.com/stretchr/testify/mock"

// Tx is an autogenerated mock type for the Tx type
type Tx struct {
	mock.Mock
}

// Commit provides a mock function with given fields:
func (_m *Tx) Commit() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Exec provides a mock function with given fields: ctx, name, query, args
func (_m *Tx) Exec(ctx context.Context, name string, query string, args ...interface{}) (db.Result, error) {
	ret := _m.Called(ctx, name, query, args)

	var r0 db.Result
	if rf, ok := ret.Get(0).(func(context.Context, string, string, ...interface{}) db.Result); ok {
		r0 = rf(ctx, name, query, args...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(db.Result)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, ...interface{}) error); ok {
		r1 = rf(ctx, name, query, args...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Query provides a mock function with given fields: ctx, name, query, args
func (_m *Tx) Query(ctx context.Context, name string, query string, args ...interface{}) (db.Rows, error) {
	ret := _m.Called(ctx, name, query, args)

	var r0 db.Rows
	if rf, ok := ret.Get(0).(func(context.Context, string, string, ...interface{}) db.Rows); ok {
		r0 = rf(ctx, name, query, args...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(db.Rows)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, ...interface{}) error); ok {
		r1 = rf(ctx, name, query, args...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// QueryRow provides a mock function with given fields: ctx, name, query, args
func (_m *Tx) QueryRow(ctx context.Context, name string, query string, args ...interface{}) db.Row {
	ret := _m.Called(ctx, name, query, args)

	var r0 db.Row
	if rf, ok := ret.Get(0).(func(context.Context, string, string, ...interface{}) db.Row); ok {
		r0 = rf(ctx, name, query, args...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(db.Row)
		}
	}

	return r0
}

// Rollback provides a mock function with given fields:
func (_m *Tx) Rollback() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ database.Tx = (*Tx)(nil)
