--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE users (
    id integer NOT NULL,
    login character varying(25),
    viewer_karma integer,
    publisher_karma integer,
    updated_on timestamp without time zone,
    created_on timestamp without time zone,
    fans_count integer DEFAULT 0,
    dmca_violation boolean,
    terms_of_service_violation boolean,
    subscriptions_count integer DEFAULT 0,
    comments_count integer DEFAULT 0,
    unread_messages_count integer DEFAULT 0,
    live boolean,
    stream_count integer,
    broadcaster boolean,
    views_count integer DEFAULT 0,
    deleted_on timestamp without time zone,
    playlist_id integer,
    publisher_guard character varying(255),
    mature boolean,
    mature_lock boolean,
    abuse_reported boolean,
    language character varying(255),
    category character varying(255),
    taglist text,
    chat_activity integer DEFAULT 0,
    subcategory character varying(255),
    status character varying(255),
    account_balance integer,
    directory_hidden boolean,
    referrer text,
    user_agent text,
    remote_ip text,
    spam boolean,
    creator_client_application_id integer,
    partner_account_balance integer,
    flagged_suspicious boolean,
    broadcast_count integer,
    email text,
    last_remote_ip text,
    last_login text,
    title text,
    delay integer,
    game text,
    password_digest character varying(255),
    site_oauth2_token text,
    broadcaster_software character varying(255),
    partner_preferred_email character varying(255),
    vods_saved_forever boolean,
    game_id integer,
    broadcaster_language character varying(255),
    password_created_on timestamp without time zone,
    stream_key character varying(255),
    birthday date,
    displayname character varying(25),
    description text,
    profile_image text,
    last_login_change_date timestamp without time zone,
    login_release_date timestamp without time zone,
    renamed_login_block_record boolean DEFAULT false,
    location text
);


--
-- Name: user_email_properties; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE user_email_properties (
    id integer NOT NULL,
    user_id integer,
    email_verified boolean,
    email_verification_code text,
    email_verification_code_time timestamp without time zone,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    block_gaming_newsletter_email boolean,
    block_broadcaster_newsletter_email boolean,
    block_all_email boolean,
    block_vodupload_email boolean
);


--
-- Name: user_email_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_email_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_email_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_email_properties_id_seq OWNED BY user_email_properties.id;


--
-- Name: user_moderation_properties; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE user_moderation_properties (
    id integer NOT NULL,
    user_id integer,
    banned_until timestamp without time zone,
    dmca_violation_count integer,
    tos_violation_count integer,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


--
-- Name: user_moderation_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_moderation_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_moderation_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_moderation_properties_id_seq OWNED BY user_moderation_properties.id;


--
-- Name: user_phone_number_properties; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE user_phone_number_properties (
    id integer NOT NULL,
    user_id integer NOT NULL,
    phone_number_verification_code text,
    phone_number_verification_sent_at timestamp without time zone,
    phone_number_verified boolean,
    phone_number text,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


--
-- Name: user_role_properties; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE user_role_properties (
    id integer NOT NULL,
    user_id integer NOT NULL,
    admin boolean DEFAULT false NOT NULL,
    subadmin boolean DEFAULT false NOT NULL,
    global_mod boolean DEFAULT false NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


--
-- Name: user_role_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_role_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_role_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_role_properties_id_seq OWNED BY user_role_properties.id;


--
-- Name: user_two_factor_auth_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_two_factor_auth_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_two_factor_auth_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_two_factor_auth_properties_id_seq OWNED BY user_phone_number_properties.id;


--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE users_id_seq OWNED BY users.id;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY user_email_properties ALTER COLUMN id SET DEFAULT nextval('user_email_properties_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY user_moderation_properties ALTER COLUMN id SET DEFAULT nextval('user_moderation_properties_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY user_phone_number_properties ALTER COLUMN id SET DEFAULT nextval('user_two_factor_auth_properties_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY user_role_properties ALTER COLUMN id SET DEFAULT nextval('user_role_properties_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY users ALTER COLUMN id SET DEFAULT nextval('users_id_seq'::regclass);

--
-- Name: user_email_properties_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_email_properties
    ADD CONSTRAINT user_email_properties_pkey PRIMARY KEY (id);


--
-- Name: user_email_properties_user_id_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_email_properties
    ADD CONSTRAINT user_email_properties_user_id_key UNIQUE (user_id);


--
-- Name: user_moderation_properties_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_moderation_properties
    ADD CONSTRAINT user_moderation_properties_pkey PRIMARY KEY (id);


--
-- Name: user_moderation_properties_user_id_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_moderation_properties
    ADD CONSTRAINT user_moderation_properties_user_id_key UNIQUE (user_id);


--
-- Name: user_role_properties_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_role_properties
    ADD CONSTRAINT user_role_properties_pkey PRIMARY KEY (id);


--
-- Name: user_role_properties_user_id_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_role_properties
    ADD CONSTRAINT user_role_properties_user_id_key UNIQUE (user_id);


--
-- Name: user_two_factor_auth_properties_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_phone_number_properties
    ADD CONSTRAINT user_two_factor_auth_properties_pkey PRIMARY KEY (id);


--
-- Name: user_two_factor_auth_properties_user_id_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY user_phone_number_properties
    ADD CONSTRAINT user_two_factor_auth_properties_user_id_key UNIQUE (user_id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: index_login_release_date; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index_login_release_date ON users USING btree (login_release_date);


--
-- Name: index_users_on_email; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index_users_on_email ON users USING btree (email);


--
-- Name: index_users_on_lower_email; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index_users_on_lower_email ON users USING btree (lower(email));

--
-- Name: index_users_on_remote_ip; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX index_users_on_remote_ip ON users USING btree (remote_ip) WHERE (remote_ip IS NOT NULL);


--
-- Name: unique_index_users_on_login; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX unique_index_users_on_login ON users USING btree (login);


--
-- Name: user_mod_props_banned_until_idx; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX user_mod_props_banned_until_idx ON user_moderation_properties USING btree (banned_until);


--
-- Name: users_displayname_lower_uniq; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX users_displayname_lower_uniq ON users USING btree (lower((displayname)::text));


--
-- Name: user_ad_properties; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE user_ad_properties (
    id integer NOT NULL,
    user_id integer NOT NULL,
    block_non_public_ads boolean,
    ad_test_partner boolean,
    prerolls_disabled boolean,
    postrolls_disabled boolean,
    fight_ad_block boolean,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


--
-- Name: user_ad_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_ad_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_ad_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_ad_properties_id_seq OWNED BY user_ad_properties.id;


--
-- Name: user_broadcast_properties; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE user_broadcast_properties (
    id integer NOT NULL,
    user_id integer NOT NULL,
    can_rebroadcast boolean,
    delay_controls_enabled boolean,
    delay_length integer,
    last_broadcast_time timestamp without time zone,
    last_broadcast_id text,
    source_restricted boolean,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    last_live_notification_sent timestamp without time zone
);


--
-- Name: user_broadcast_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_broadcast_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_broadcast_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_broadcast_properties_id_seq OWNED BY user_broadcast_properties.id;



--
-- Name: user_channel_properties; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE user_channel_properties (
    id integer NOT NULL,
    user_id integer,
    displayname text,
    description text,
    about text,
    redirect_channel character varying(25),
    disable_chat boolean DEFAULT false NOT NULL,
    primary_team_id integer,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    can_create_offline_playlist boolean DEFAULT false NOT NULL
);


--
-- Name: user_channel_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_channel_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_channel_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_channel_properties_id_seq OWNED BY user_channel_properties.id;


--
-- Name: user_image_properties; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE user_image_properties (
    id integer NOT NULL,
    user_id integer,
    channel_offline_image text,
    profile_banner text,
    profile_image text,
    profile_banner_background_color character(7),
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


--
-- Name: user_image_properties_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE user_image_properties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: user_image_properties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE user_image_properties_id_seq OWNED BY user_image_properties.id;

ALTER TABLE ONLY user_ad_properties ALTER COLUMN id SET DEFAULT nextval('user_ad_properties_id_seq'::regclass);
ALTER TABLE ONLY user_broadcast_properties ALTER COLUMN id SET DEFAULT nextval('user_broadcast_properties_id_seq'::regclass);
ALTER TABLE ONLY user_channel_properties ALTER COLUMN id SET DEFAULT nextval('user_channel_properties_id_seq'::regclass);

ALTER TABLE ONLY user_ad_properties
    ADD CONSTRAINT user_ad_properties_pkey PRIMARY KEY (id);

ALTER TABLE ONLY user_broadcast_properties
    ADD CONSTRAINT user_broadcast_properties_pkey PRIMARY KEY (id);

ALTER TABLE ONLY user_channel_properties
    ADD CONSTRAINT user_channel_properties_pkey PRIMARY KEY (id);



--
-- PostgreSQL database dump complete
--

--
-- Manually appended reservation db details
--

CREATE TABLE login_reservations (
    login character varying(25),
    type character varying(25),
    reason character varying(255),
    expires_on timestamp without time zone
);

--
-- Reservation db complete
--

--
-- Name: index_channel_properties_on_redirect_channel; Type: INDEX; Schema: public; Owner: -; Tablespace:
--

CREATE INDEX index_channel_properties_on_redirect_channel_lower ON user_channel_properties USING btree (lower(redirect_channel));