#!/bin/bash

# TESTING: Comment out the call to the beanstalk deployment script and make sure
# the values are printed out that you export

# set +x
cat <<EOF > awskeys
AWS_SECRET_ACCESS_KEY=$AWS_SECRET_KEY
AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY
PYTHONUNBUFFERED=1
EOF

# deploy_log.txt is used to determine the status of environment deployments
touch deploy_log.txt

function cleanup() {
  err=$?
  echo "==> DEPLOY STATUS REPORT <=="
  cat deploy_log.txt
  rm -f deploy_log.txt
  rm -f awskeys
  exit $err
}

trap cleanup INT TERM EXIT

push_queue(){
  element_to_store="$1"
  queue+=($element_to_store)
}
pop_queue(){
  args=${queue[0]}
  queue=("${queue[@]:1}")
}

# queue is used to capture environments to be deployed to
queue=()
regions=( "us-west-2" "us-east-1" )
types=( "server" "worker" )

echo "==> PARSING ENV VARS <=="

IFS='-' read -ra PIECES <<< "$ENVIRONMENT"

LENGTH=${#PIECES[@]}
environment=${PIECES[0]}

if [[ "${LENGTH}" -eq "1" ]]; then
# if length is one, deploy api and worker to each region in provided environment
for region in "${regions[@]}"
do
  for type in "${types[@]}"
  do
    push_queue "${region}-${environment}-${type}"
  done
done
elif [[ "${LENGTH}" -eq "4" ]]; then
# if length is 4, deploy api and worker to provided region and environment
  region="${PIECES[1]}-${PIECES[2]}-${PIECES[3]}"
  for type in "${types[@]}"
  do
    push_queue "${region}-${environment}-${type}"
  done
elif [[ "${LENGTH}" -eq "5" ]]; then
# if length is 5, deploy provided type to provided region and provided environment
  region="${PIECES[1]}-${PIECES[2]}-${PIECES[3]}"
  type="${PIECES[4]}"
  push_queue "${region}-${environment}-${type}"
else
  echo "unable environment combination ${ENVIRONMENT} passed" && exit 1
fi

echo "==> DEPLOYING TO DESIRED REGIONS/ENVIRONMENTS/TYPES <=="

while [[ "${#queue}" -ne 0 ]]; do
  pop_queue
  export DEPLOY_ENVIRONMENT="${args}"
  ./scripts/jenkins_deploy_env.sh
  rc=$?; if [[ $rc != 0 ]]; then
    echo "${args}: failure" >> deploy_log.txt
    exit $rc
  fi
  echo "${args}: success" >> deploy_log.txt
done
