# Users Service API

## Endpoints

| Function | Method | Url | Auth needed |
|-------------------------------------|:------:|------------------------------------------------------------------------|:------------:|
| [Fetch properties for a multiple channels](#get-channelsnamexangoldnamelirik) | GET | `/channels?name=<name>&inline_identifier_validation=false` | N/A |
| [Fetch properties for a single user](#get-usersid) | GET | `/users/:id`  |
| [Fetch properties for multiple users](#get-usersid27953914id27953915) | GET | `/users?id=<id>&login=<login>&email=<email>&displayname=<displayname>&not_deleted=true&no_tos_violation=true&no_dmca_violation=true&skip_identifier_validation=false&inline_identifier_validation=false` |
| [Fetch properties for users that have a login matching a pattern](#get-userslogin_likesuper) | GET | `/users?login_like=<login pattern(postgres)>` |
| [Rename eligiblity for a given user](#get-usersidrename_eligible) | GET | `/users/:id/rename_eligible`  | N/A |
| [Fetch properties for banned users](#get-banned_usersuntil2016-09-17t113318-0800) | GET | `/banned_users?until=<RFC3339DateTime>`| N/A |
| [Fetch the type for multiple logins](#get-logins) | GET | `/logins?login=<login>` | N/A |
| [Fetch Global Privileged Users](#get-global_privileged_users) | GET | `/global_privileged_users?role=<role>` | N/A |
| [Ban a user](#put-usersidban) | PUT | `/users/:id/ban`  | N/A |
| [Unban a user](#delete-usersidban)| DELETE | `/users/:id/ban`  | N/A |
| [Set User Properties](#patch-usersid) | PATCH  | `/users/:id`| N/A |
| [Add a DMCA Strike](#put-usersiddmca_strike) | PUT | `/users/:id/dmca_strike`| N/A |
| [Remove a DMCA Strike](#delete-usersiddmca_strike) | DELETE | `/users/:id/dmca_strike`| N/A |
| [Confirm phone number](#post-usersidphone_number_code) | POST| `/users/:id/verify_phone_number` | N/A |
| [Set Image Metadata](#patch-usersidimagesmetadata) | PATCH  | `/users/:id/images/metadata`  | N/A |
| [Create User](#post-users) | POST| `/users` | N/A |
| [Upload Image](#patch-usersidimages)| PATCH  | `/users/:id/images`  | users::edit_user_by_id_internal (Cartman) |
| [Soft Delete User](#delete-usersidadminldaplogin) | DELETE | `/users/:id?admin=ldapLogin`  | N/A |
| [Hard Delete User](#delete-usersiddestroytrueadminldaplogin) | DELETE | `/users/:id?destroy=true&admin=ldapLogin` | N/A |
| [Undelete User](#patch-usersidundeleteadminldaplogin) | PATCH  | `/users/:id/undelete?&admin=ldapLogin` | N/A |
| [Edit Channel Internal](#patch-channels)| PATCH  | `/channels` | N/A |
| [Edit Channel External](#patch-channelseditorid)| PATCH  | `/channels/editor/:id`  | users::edit_channel (Cartman) |
| [Add Reservation Record](#post-reservations)| POST  | `/reservations`  | N/A |
| [Update Reservation Record](#patch-reservations)| PATCH  | `/reservations`  | N/A |
| [Get Reservation Records](#get-reservations)| GET  | `/reservations`  | N/A |
| [Delete Reservation Records](#delete-reservations)| DELETE  | `/reservations/:login`  | N/A |


## Responses

We'll abide by the following HTTP response codes

| HTTP Response Code | Meaning  | Expected Behaviour  |
|:------------------:|----------------------------|---------------------------------------------|
| 200 | OK, has response body| None |
| 204 | OK, no response body | None |
| 400 | Bad request/identifiers | Correct your identifiers  |
| 403 | Forbidden| Operation is not allowed  |
| 404 | Resource not found| Check url, or user not found |
| 422 | Unprocessable Entity | Request cannot be processed, change request |
| 431 | Request headers too large  | Break up the request into multiple |
| 500 | Server Error| Try again  |
| 503 | Resource Pool Exhausted | Try again later, back off, break circuit |
| 504 | Timeout  | Try again  |

Any other error codes should be reported as bugs to us.

All responses have `Content-Type: application/json` regardless of requested `Accept-Encoding`.

## Response Objects

### GET /channels?name=xangold&name=lirik

Channel property fetches require a `name` parameter. 
 * `name` may be a single channel name or repeatedly specified (e.g. `?name=x&name=y&name=z` 
 * to provide up to 100 channels

 These parameters should be URL Encoded. Providing the query parameter `inline_identifier_validation=true` will return channels with valid identifiers and errors for each invalid identifier.

Successful GET requests will return the following object:

    {
      "results": [
        { "id": 39141973,
          "directory_hidden": false,
          "broadcaster_language": "en",
          "status": "[Twitch Staff] Programming ",
          "game": "Programming",
          "game_id": 458688,
          "name": "xangold",
        }
      ]
    }

If you request multiple channels worth of properties, and one of the channels does not exist it will not be represented in the result set. Do not rely on the ordering of the channel results.

### Examples


#### Fetch properties
**Request**
**URL** `/channels?name=xangold&name=wimpywimpywimpy&name=rothgar`
**body**

    {
      "results": [
        { "id": 39141973,
          "directory_hidden": false,
          "broadcaster_language": "en",
          "status": "[Twitch Staff] Programming ",
          "game": "Programming",
          "game_id": 458688,
          "name": "xangold",
        },
        { "id": 39141972,
          "directory_hidden": false,
          "broadcaster_language": "en",
          "status": "[Twitch Staff] Programming ",
          "game": "Programming",
          "game_id": 458688,
          "name": "wimpywimpywimpy",
        },
        { "id": 39141971,
          "directory_hidden": false,
          "broadcaster_language": "en",
          "status": "[Twitch Staff] Programming ",
          "game": "Programming",
          "game_id": 458688,
          "name": "rothgar",
        }
      ]
    }

**Request**
**URL** `/channels?name=xangold&name=wimpywimpywimpy&name=rothgar&name=i_dont_exist&inline_identifier_validation=true`
**body**

    {
      "results": [
        { "id": 39141973,
          "directory_hidden": false,
          "broadcaster_language": "en",
          "status": "[Twitch Staff] Programming ",
          "game": "Programming",
          "game_id": 458688,
          "name": "xangold",
        },
        { "id": 39141972,
          "directory_hidden": false,
          "broadcaster_language": "en",
          "status": "[Twitch Staff] Programming ",
          "game": "Programming",
          "game_id": 458688,
          "name": "wimpywimpywimpy",
        },
        { "id": 39141971,
          "directory_hidden": false,
          "broadcaster_language": "en",
          "status": "[Twitch Staff] Programming ",
          "game": "Programming",
          "game_id": 458688,
          "name": "rothgar",
        }
      ],
      "bad_identifiers": [
          {
              "Name": "name",
              "Value": "i_dont_exist"
          }
      ]
    }

### GET /users/:ID
e.g. [http://users-service.dev.us-west2.twitch.tv/users/279539145](http://users-service.dev.us-west2.twitch.tv/users/279539145)

User property fetches require an identifier. The single endpoint only accepts User IDs as that identifier.

404 will be returned if the User is not found in the database.

`not_deleted=true`, `no_tos_violation=true`, `no_dmca_violation=true` are query query parameters used to determine the user is available. If the user fails any of these checks, 422 will be returned.

Successful GET requests will return the following object.

    {  
       "id":27953914,
       "login":"golfing",
       "birthday": "1980-02-29T00:00:00Z",
       "dmca_violation":null,
       "terms_of_service_violation":null,
       "deleted_on":null,
       "language":"en",
       "category":"gaming",
       "referrer":"https://secure.justin.tv/naslseasonone/subscribe/31/signup",
       "user_agent":"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36",
       "remote_ip":"192.168.241.92",
       "email":"notgolf@twitch.tv",
       "last_login":"2016-07-05 16:25:46",
       "banned_until":null,
       "dmca_violation_count":null,
       "tos_violation_count":null,
       "admin":true,
       "subadmin":false,
       "global_mod":false,
       "displayname":"GolfinG",
       "description":"profile changes",
       "profile_image":{  
          "150x150":{  
             "width":150,
             "height":150,
             "url":"https://static-cdn.jtvnw.net/jtv_user_pictures/golfing-profile_image-36d5e1575686d73b-150x150.png"
          },
          "28x28":{  
             "width":28,
             "height":28,
             "url":"https://static-cdn.jtvnw.net/jtv_user_pictures/golfing-profile_image-36d5e1575686d73b-28x28.png"
          },
          "300x300":{  
             "width":300,
             "height":300,
             "url":"https://static-cdn.jtvnw.net/jtv_user_pictures/golfing-profile_image-36d5e1575686d73b-300x300.png"
          },
          "50x50":{  
             "width":50,
             "height":50,
             "url":"https://static-cdn.jtvnw.net/jtv_user_pictures/golfing-profile_image-36d5e1575686d73b-50x50.png"
          },
          "600x600":{  
             "width":600,
             "height":600,
             "url":"https://static-cdn.jtvnw.net/jtv_user_pictures/golfing-profile_image-36d5e1575686d73b-600x600.png"
          },
          "70x70":{  
             "width":70,
             "height":70,
             "url":"https://static-cdn.jtvnw.net/jtv_user_pictures/golfing-profile_image-36d5e1575686d73b-70x70.png"
          }
       },
       "updated_on":"2016-07-05T23:25:46.546891Z",
       "created_on":"2012-02-04T05:31:16.359265Z",
       "email_verified":true,
       "email_verification_code":null,
       "email_verification_code_time":null,
       "block_gaming_newsletter_email":null,
       "block_broadcaster_newsletter_email":null,
       "block_all_email":true,
       "phone_number_verification_code":null,
       "phone_number_verification_sent_at":null,
       "phone_number_verified":true
    }

### GET /users?id=27953914&id=27953915

e.g. [http://users-service.dev.us-west2.twitch.tv/users/279539145](http://users-service.dev.us-west2.twitch.tv/users?id=27953914&id=27953915)

This endpoint accepts `id=`, `login=`, `email=` and `displayname=`  specifiers in the query string. Multiples of each and or combinations are accepted. e.g. `/users?id=5&id=7&login=gamble.`

Multiple identifiers will simply return all of the specified users if found by identifier in an `OR` fashion. By default, identifiers will be validated and any invalid identifiers will fail the request. Providing the query parameter `inline_identifier_validation=true` will return users with valid identifiers and errors for each invalid identifier. If identifier validation needs to be skipped, pass `skip_identifier_validation=true`.

Requests for identifiers of proper format but not present in the datastore will be omitted from the response. For example, if you request id 5 and id 6 where id 6 doesn't exist in the datastore you will get one user object back in the "results" list. An empty result set will be returned if no matches are made.

Successful GET requests will return a JSON list called "results" filled with user objects identical to the single user endpoint


    {
      "results": [
        {
          "id": 27953914,
          "login": "golfing",
          "email": "notgolf@twitch.tv",
          ...
        },
        {
          "id": 27953915,
          "login": "ros026",
          "email": "notRos026@twitch.tv",
            ...
        }
      ]
    }

#### GET /users?id=27953914&id=27953915&id=bad&inline_identifier_validation

    {
      "results": [
        {
          "id": 27953914,
          "login": "golfing",
          "email": "notgolf@twitch.tv",
          ...
        },
        {
          "id": 27953915,
          "login": "ros026",
          "email": "notRos026@twitch.tv",
            ...
        }
      ],
      "bad_identifiers": [
          {
              "Name": "id",
              "Value": "bad"
          }
      ]
    }

### GET /users?login_like=super%

e.g. [http://users-service.dev.us-west2.twitch.tv/users?login_like=super%25](http://users-service.dev.us-west2.twitch.tv/users?login_like=super%25)

This endpoint accepts a postgres pattern expression to find users that have a login matching the pattern. Although postgres supports two wildcards `%` and `_`, only `%` is supported as requests involving `_` are expensive and are likely to timeout. If multiple like params are specified, only the first one is used and the rest are ignored. 

You may have to URLEncode the wildcard in the request. e.g `/users?login_like=super%` may have to be requested as `/users?login_like=super%25`

Successful GET requests will return a JSON list called "results" filled with user objects identical to the single user endpoint. The results are capped at 10 so you will be able to retrieve at most 10 users.


    {
      "results": [
        {
          "id": 146865812,
          "login": "superbiacao",
          ...
        },
        {
          "id": 30479104,
          "login": "supermarcezerg",
            ...
        }
      ]
    }
    
    
### GET /users/:id/rename_eligible

e.g. [http://users-service.dev.us-west2.twitch.tv/users/279539145/rename_eligible](http://users-service.dev.us-west2.twitch.tv/users/279539145/rename_eligible)

This endpoint provides a boolean regarding whether or not a user is eligible for login rename, based on the last time they changed their name and the login rename cooldown. It will also provide a timestamp for when they will be eligible. This timestamp will be the current time if they have never used a login rename.

404 will be returned if the User is not found in the database.

Successful GET requests will return the following object.

    {
      "rename_eligible": true,
      "rename_eligible_on": "2017-01-05T11:36:23.317792559-08:00"
    }

### GET /banned_users?until=2016-09-17T11:33:18-08:00

e.g. [http://users-service.dev.us-west2.twitch.tv/banned_users?until=2016-09-17T11:33:18-08:00](http://users-service.dev.us-west2.twitch.tv/banned_users?until=2016-09-17T11:33:18-08:00)

This endpoint accepts an RFC3339 formatted datetime string as `until` in the query string.

Requests for a banned until where no results are found will simply return an empty list.

Successful GET requests will return a JSON list called "results" filled with user objects identical to the single user get endpoint


    {
      "results": [
        {
          "id": 27953914,
          "login": "golfing",
          "email": "notgolf@twitch.tv",
          ...
        },
        {
          "id": 27953915,
          "login": "ros026",
          "email": "notRos026@twitch.tv",
            ...
        }
      ]
    }

### GET /logins

e.g. [http://users-service.dev.us-west2.twitch.tv/logins?login=comrade&login=twitchpresents](http://users-service.dev.us-west2.twitch.tv/logins?login=comrade&login=twitchpresents)

This endpoint accepts `login=` specifiers in the query string.

For each login that is found, a login type object will be returned. This includes a user's id and login, along with type. Type is used to designate whether or not this is a User or Block Record, and will have additional types in the future.

Requests for identifiers of proper format but not present in the datastore will be omitted from the response. For example, if you request login `bob` and login `thisisnttakenyet` where login `thisisnttakenyet` doesn't exist in the datastore you will get one login type object back in the "results" list. An empty result set will be returned if no matches are made.

Successful GET requests will return a JSON list called "results" filled with login type objects


    {
      results: [
        {
          id: "32264361",
          login: "comrade",
          type: "User"
        },
        {
          id: "149747285",
          login: "twitchpresents",
          type: "User"
        }
      ]
    }

### GET /global_privileged_users

e.g. [http://users-service.dev.us-west2.twitch.tv/global_privileged_users](http://users-service.dev.us-west2.twitch.tv/global_privileged_users)

This endpoint fetches the list of special user logins that have one or more of the following privileges - admin, subadmin, global_mod

Successful GET requests will return a JSON with three lists, each contining the user logins for the corresponding role

    {
          "admins": [
            "mellified_man",
            "wrecertrecan25"
          ],
          "subadmins": [
                "eleine",
                "y5dnudj9"
          ],
          "global_mods": [
                "the_sparcmac"
          ]
    }

The default response is to return the all three lists. However, if only a list belonging to a particular role is desired, those can be fetched by passing in the optionl role parameter value

e.g. [http://users-service.dev.us-west2.twitch.tv/global_privileged_users?role=subadmin&role=global_mod](http://users-service.dev.us-west2.twitch.tv/global_privileged_users?role=subadmin&role=global_mod)

    {
          "subadmins": [
            "eleine",
                "y5dnudj9"
          ],        
          "global_mods": [
              "the_sparcmac"
          ]
    }

The only acceptable values for the role parameter are `admin`, `subadmin` and `global_mod` 

### PUT /users/:id/ban
- The ban endpoint will use the request body to modify the user. Required parameters are `reason`(string), `type`(string), `is_permanent`(bool), and `skip_ip_ban`(bool). Not required but highly recommended is `reporter`(string). These parameters should be specified as a JSON object.
- If you call the endpoint with empty reporter in request, when auditing the user ban, reporter field will by default as "admin".
- Successful PUT requests will return status 204 No Content.

### DELETE /users/:id/ban
The unban endpoint currently sets terms_of_service_violation and dmca_violation to false, banned_until to null, and removes the users last remote IP from the blacklist.

Successful DELETE requests will return status 204 No Content.


### PATCH /users/:id
The set user endpoint will use the request body to modify the user. Currently available properties to set are `email`(string), `new_login`(string), `displayname`(string), `language`(string), `description`(string), `email_verified`(bool), `skip_login_cooldown`(bool), `last_login`(string), `phone_number`(string), `remote_ip`(string). These parameters should be specified as a JSON object. While no parameters are technically required, please don't no-op for no reason.

`new_login` is used to request a login change for the user. The user must be eligible for a rename, which can be checked on its own via the rename_eligible endpoint. This login cooldown can be skipped by providing `skip_login_cooldown`. Also, the requested login must be available in order for the change to succeed.  If the user does not have a CJK displayname, then the next login must also be unused as a displayname. `new_login` and `displayname` should not be sent in the same set user JSON body.

An example login rename JSON body:

    {
        "new_login":"NotGarbagePete",
        "skip_login_cooldown": true
    }

`email_verified` is not needed to be set to `false` when changing a user's email. The service will set a user's `email_verified` property automatically on any non capitalization change of their email address.

An example JSON body: 

    {
       "email":"garbagepete@trashpad.com",
       "displayname": "漢漢",
       "language": "en",
       "description": "Some people like video games. I myself just like garbage. Names Pete. Nice to meet you."
    }

`phone_number` will update a user's phone number, set as unverified, and send them a text message confirmation code.

The confirmation code should be set to `/users/:id/verify_phone_number`.

An example JSON body:

    {
        "phone_number": "1231231234"
    }
 
Successful PATCH requests will return status 204 No Content.

### PATCH /users/:id/images/metadata

Sets a user's profile banner, channel offline image, and/or profile image. Also, it can set them to defaults.

```go
type ImageProperties struct {
	ID                         string       `json:"id" `
	ProfileBanner              *yimg.Images `json:"profile_banner" `
	ChannelOfflineImage        *yimg.Images `json:"channel_offline_image" `
	ProfileImage               *yimg.Images `json:"profile_image" `
	DefaultProfileBanner       *string      `json:"default_profile_banner" `
	DefaultChannelOfflineImage *string      `json:"default_channel_offline_image" `
	DefaultProfileImage        *string      `json:"default_profile_image" `
}
```

### POST /users

Creates a user and returns it's ID. Note, this is mainly for use by passport because our creating a user on our end does not mean the user can log into the site.

```go
type CreateUserProperties struct {
	Login string `json:"login" validate:"nonzero"`
	IP    string `json:"ip"`
	// Location is set from IP
	Location    string   `json:"-"`
	Birthday    Birthday `json:"birthday" validate:"nonzero"`
	Email       string   `json:"email" validate:"nonzero"`
	DeviceID    string   `json:"device_id"`
	Language    string   `json:"language"`
	Category    string   `json:"category"`
	Displayname string   `json:"-"`
}
```

### PUT /users/:id/dmca_strike
The PUT dmca_strike will increment the existing strike count by 1 

Successful PUT requests will return status 204 No Content.

### DELETE /users/:id/dmca_strike
The DELETE dmca_strike will decrement the existing strike count by 1 

Successful DELETE requests will return status 204 No Content.

### POST /users/:id/phone_number_code

The POST phone_number_code will verify the sent code against the code stored in the database. If the code is correct, the user will receive confirmation text messages.
Afterwards, the user's phone number is set as verified.

An example JSON body:

    {
        "code": "001122
    }

### PATCH /users/:id/images
This endpoint requested an image upload url to upload a customized user image. User image type includes, profile image, channel offline image and profile banner.

```go
type UploadableImage struct {
	ID  string `json:"-" `
	Editor string `json:"editor"`
	Type string `json:"type" `
	Format string `json:"format"`
}
```

* ID field will be auto filled from your request, which is the user id you want to upload image for.
* Editor is the requester for the image upload request, it could be a user themselves, an admin or a staff, editor should be their twitch id.
* Type is the image type you want to upload the image for.
* Format is the image format you want it be, it could be jpeg or png. If you send a request without specific format you want, we'll default to use png to keep high quality.

### DELETE /users/:id?admin=ldapLogin

Soft deletes a given user id which will keep their account data but they won't be able to use the site. The `admin` must be provided and must be the LDAP user name making this change. Soft deletes are undone by undeletes. A notification is published to the soft delete topic. 

### DELETE /users/:id?destroy=true&admin=ldapLogin

Hard deletes a given user id removes the user's data and cannot be reversed. The `admin` must be provided and must be the LDAP user name making this change. A notification is published to the hard delete topic.

### PATCH /users/:id/undelete?&admin=ldapLogin

Undeletes a given user id. This can only be called on soft deleted users. The `admin` must be provided and must be the LDAP user name making this change. A notification is published to the undelete topic.

### PATCH /channels
This endpoint set multiple channel properties including every field (except channel ID) in the following struct:
```go
type UpdateChannelProperties struct {
	ID                  uint64     `json:"id" validate:"nonzero"`
	DirectoryHidden     *bool      `json:"directory_hidden"`
	Broadcaster         *string    `json:"broadcaster"`
	BroadcasterLanguage *string    `json:"broadcaster_language"`
	BroadcasterSoftware *string    `json:"broadcaster_software"`
	Game                *string    `json:"game"`
	GameID              *uint64    `json:"game_id"`
	Mature              *bool      `json:"mature"`
	Status              *string    `json:"status"`
	Title               *string    `json:"title"`
	UpdatedOn           *time.Time `json:"updated_on"`
	ViewsCount          *uint64    `json:"views_count"`

	BlockNonPublicAds *bool `json:"block_non_public_ads"`
	PrerollsDisabled  *bool `json:"prerolls_disabled"`
	PostrollsDisabled *bool `json:"postrolls_disabled"`
	FightAdBlock      *bool `json:"fight_ad_block"`

	LastBroadcastTime        *time.Time `json:"last_broadcast_time"`
	LastBroadcastID          *string    `json:"last_broadcast_id"`
	LastLiveNotificationSent *time.Time `json:"last_live_notification_sent"`

	About           *string `json:"about"`
	RedirectChannel *string `json:"redirect_channel"`
	PrimaryTeamID   *uint64 `json:"primary_team_id"`
	DisableChat     *bool   `json:"disable_chat"`
}
```
* GameID field will be auto looked up if you are providing a valid game name.
* Updated on should be auto updated upon any updates
* RedirectChannel field only accepts valid channel id including 0-9, a-z, A-Z. Should not use this field to do page redirect like "p/help".

Successful PATCH requests will return status 204 No Content.

### PATCH /channels/editor/:id

The same as `PATCH /channels`, however an editor id is provided that is the user themselves, an admin or a staff. Editor should be their twitch id.

## Error Objects
In the event of a graceful error, users service should return an object of the following format

    {
        "status": 404,
        "message": "No properties found for this user identifier",
        "error": "Not Found"
    }

### PATCH /reservations

Update reserved record in the reservation DB. If the record doesn't exist, the request will get a 500. You should use POST request instead to update an existing record. 

Note that expires_on should always be sometime later than the timestamp of the existing block record has and a null expires_on field indicates this record never expires.

Example body:
```
{"login":"gigacat", "type":"Reserved Record", "reason":"testing", "expires_on":"2018-01-23T09:11:11.616456Z"}
```

### POST /reservations

Add a new reserved record in the reservation DB. If the record already exists, the request will get a 500. You should use PATCH request instead to update an existing record. 

Note that expires_on should always be sometime later than the current timestamp and a null expires_on field indicates this record never expires.

Example body:
```
{"login":"gigacat", "type":"Reserved Record", "reason":"testing", "expires_on":"2018-01-23T09:11:11.616456Z"}
```

### GET /reservations

This endpoint is used to query reservation db for reserved record. Sample URL /reservations?login=gigacat


### DELETE /reservations

This endpoint is used to delete reservation db for reserved record. Sample URL /reservations/gigacat


