# Client

There are three golang clients: `usersclient_internal`, `usersclient_external`, `channels`.

| Name | Package | Description |
|---|---|---|
| `usersclient_internal` | `code.justin.tv/web/users-service/client/usersclient_internal` | Users API client for **internal** services. Data returned includes PII |
| `usersclient_external` | `code.justin.tv/web/users-service/client/usersclient_external` | Users API client for **external** services. Data returned includes PII when requestor is valid, otherwise excludes PII |
| `channels` | `code.justin.tv/web/users-service/client/channels` | Channels API client |

## Creation

```go
import (
    "context"

    "code.justin.tv/foundation/twitchclient"
    "code.justin.tv/web/users-service/client/usersclient_internal"
)

...

    conf := twitchclient.ClientConf{
        Host: "http://users-service.dev.us-west2.twitch.tv",
    }

    client, err := usersclient_internal.NewClient(conf)
    if err != nil {
        // Handle error
    }
```

## Usage

Gets users by email and print them.

```go
    ctx := context.Background()

    result, err := client.GetUsers(ctx, &models.FilterParams{
        Emails: emails,
    }, nil)
    if err != nil {
        // Handle error
    }

    fmt.Println(result.Results)
```

## Error Handling

Inspects error for status code. [Here's a full list of status codes](/doc/api.md#responses).

```go
import (
    "context"

    usersclient "code.justin.tv/web/users-service/client"
)

...

    ctx := context.Background()

    result, err := client.GetUsers(ctx, &models.FilterParams{
        Emails: emails,
    }, nil)
    cErr, ok := err.(usersclient.Error)
    if !ok {
        // This should never happen. Please alert #core-user immediately if it does
    }

    switch cErr.StatusCode() {
        case 400:
        case 404:
        case 500:
        default:
    }
```

Switching on explicit types. [Here's a full list of the types](/models/common_errors.go#L9).

```go
import (
    "context"

    usersclient "code.justin.tv/web/users-service/client"
    usermodels "code.justin.tv/web/users-service/models"
)

...

    ctx := context.Background()

    result, err := client.GetUsers(ctx, &models.FilterParams{}, nil)
    switch err.(type) {
        case models.ErrNoIdentifiers:
            // Handle error
        default:
            // Fall back to handling by status code via usersclient.Error
    }
```
