# Configuration

This document outlines how to add new configuration values to users-service. Configuration is broken into two catergories: variables and secrets.

Configuration is defined in code and a struct is generated to provide environment and regional specific values that are resolved at run-time.

Environments:

- development: values used locally
- test: values used in integration test during build
- staging: values used in staging environment
- production: values used in production environment

Regions:

- us-west-2: values used in AWS us-west-2 region
- us-east-1: values used in AWS us-east-1 region

## Adding environments or regions

New environments and regions can be added to the respective struct tags [here](/configs/config.go#L14). Then run `go generate`.

## Variables

Instructions:

1. New variables are added to [Config](/configs/config.go). Run `go generate` in `/configs` to update the multi region configuration.
2. Define the environment and region values in [Defined](/configs/defined.go).

Examples:

- [Simple value](/configs/config.go#L41)
- Struct values: [1](/configs/config.go#L16-L17), [2](/configs/config.go#L95-L102), [3](/configs/config.go#L117-L127)

## Secrets

Instructions:

1. New secrets are added to [Config](/configs/config.go) as struct tags. They can be parameterized by environment and region.

Examples:

- [Rollbar token](/configs/config.go#L47)
- [Struct specific secrets](/configs/config.go#L97-L98)
