# Errors

Users service reports errors to rollbar to help us debug issues. [Here is our rollbar dashboard.](https://rollbar.com/Twitch/Users)

## Best practices

Here's a list of best practices and tips when returning errors in our codebase.

### HTTP status codes

You can define a `models.CodedError` error variable to define an error wth a message and HTTP status code. If this error is unhandled and is returned by the API, it's error code will be used. [Here's some example codes.](https://git-aws.internal.justin.tv/web/users-service/blob/master/models/common_errors.go)

### Capturing stack traces

You can capture the stacktrace when an error is created with `errx.New`. This error will also be logged to rollbar.

### Defining whether an error should be logged or not

`models.CodedError` implements `ServiceError` interface which has a `ShouldLog() bool` method. An error can have that method return `true` to logged to rollbar when it is unhandled and returned by the API.

### Avoid logging known errors to rollbar

The `internal/utils` package has helper methods to identify common, known errors: hystrix, timeout, and context canceled. Instead of logging these (noisy) errors to rollbar, create metrics for them. 
