# Events Published to SNS

users-service publishes user change events to SNS topics so you can act on changes. Events fall into the following categories:

* Announcement: An event that has a timestamp and optionally associated data like create_user and ban_user. 
* Change Notification: An event where a part of a user object has changed like update_user and update_channel. With these events, the data prior to the change is in `Original` and `Changes` or `Changed` contains only fields that changed.

## Topic ARNs

| Event Name         | Staging                                                          | Production                                                     | 
|--------------------|--------------------------------------------|--------------------------------------------------------------------------------------|
| create_user        | `arn:aws:sns:us-west-2:465369119046:notification-user-created`   |`arn:aws:sns:us-west-2:641044725657:notification-user-created`  |
| rename_user        | `arn:aws:sns:us-west-2:465369119046:user_rename_events`          |`arn:aws:sns:us-west-2:641044725657:user_rename_events`         |
| ban_user           | `arn:aws:sns:us-west-2:465369119046:user_moderation_events`      |`arn:aws:sns:us-west-2:641044725657:user_moderation_events`     |
| unban_user         | `arn:aws:sns:us-west-2:465369119046:user_moderation_events`      |`arn:aws:sns:us-west-2:641044725657:user_moderation_events`     |
| update_user        | `arn:aws:sns:us-west-2:465369119046:user_mutation_events`        |`arn:aws:sns:us-west-2:641044725657:user_mutation_events`       | 
| update_user_images | `arn:aws:sns:us-west-2:465369119046:user_mutation_events`        |`arn:aws:sns:us-west-2:641044725657:user_mutation_events`       | 
| soft_delete_user   | `arn:aws:sns:us-west-2:465369119046:user_soft_delete_events`     |`arn:aws:sns:us-west-2:641044725657:user_soft_delete_events`    | 
| hard_delete_user   | `arn:aws:sns:us-west-2:465369119046:notification-user-destroyed` |`arn:aws:sns:us-west-2:641044725657:notification-user-destroyed`| 
| undelete_user      | `arn:aws:sns:us-west-2:465369119046:user_undelete_events`        |`arn:aws:sns:us-west-2:641044725657:user_undelete_events`       | 
| update_channel     | `arn:aws:sns:us-west-2:465369119046:channel_mutation_events`     |`arn:aws:sns:us-west-2:641044725657:channel_mutation_events`    | 

## How to add subscription to our events
* Require Permission: Cut a PR in users-service to add your account which is going to subscribe to our event to the policy. Here is an [pr example](https://git-aws.internal.justin.tv/web/users-service/pull/339/files#diff-a3f77a160af56623abe271d80b0f0b69R98).
  * If the policy for the topic you want to subscribe is not existing at all, add a new one as the pr did
  * If the policy already exists and you have one account, just add your account like [this](https://git-aws.internal.justin.tv/web/users-service/blob/master/terraform/modules/users-service/sns.tf#L52).
  * If the polic already exists and you have staging and production account, define a variable that has a map with values for production and staging. Then, add a lookup to the policy i.e. `${lookup(var.devsuccess_iam_arns, var.environment)}`
  * If PR approved, go ahead to merge that and let us know, we'll run terraform for you.

Note: `notification-user-destroyed` topic policies are set in the `users-service-legacy` module.

* Create a lambda: One option is to have a lambda job consumes our event, [web/searchindexer](https://git-aws.internal.justin.tv/web/searchindexer) sets an good [example](https://git-aws.internal.justin.tv/web/searchindexer/blob/master/scripts/aws_lambda_job.py#L56) to read our events. 
* Set Up Cross-Account Permissions for Lambda: the example searchindexer above is subscribing from the same account, you might need extra work to do with cross account efforts. An [article](http://docs.aws.amazon.com/lambda/latest/dg/with-sns-create-x-account-permissions.html) to read.
## create_user
**Event Trigger:** A new user was created

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:notification-user-created`
* *Production:* `arn:aws:sns:us-west-2:641044725657:notification-user-created`

**Event Model:**
```
type SNSCreationEvent struct {
	UserID      string    `json:"user_id"`
	Login       string    `json:"login"`
	Displayname string    `json:"displayname"`
	Timestamp   time.Time `json:"timestamp"`
}
```

## rename_user
**Event Trigger:** A user's login or display name was updated

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:user_rename_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:user_rename_events`

**Event Model:**
```
type SNSRenameEvent struct {
	UserID    string         `json:"user_id"`
	Data      *SNSRenameData `json:"data"`
	Timestamp time.Time      `json:"timestamp"`
}

type SNSRenameData struct {
	Original *SNSRenameProperties `json:"original"`
	Changes  *SNSRenameProperties `json:"changes"`
}

type SNSRenameProperties struct {
	Login       *string `json:"login,omitempty"`
	Displayname *string `json:"displayname,omitempty"`
}
```

## ban_user
**Event Trigger:** A user was banned 

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:user_moderation_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:user_moderation_events`

**Event Model:**
```
type SNSBanEvent struct {
	UserID                  string    `json:"user_id"`
	DmcaViolation           bool      `json:"dmca_violation" `
	TermsOfServiceViolation bool      `json:"terms_of_service_violation" `
	Timestamp               time.Time `json:"timestamp"`
}
```

## unban_user
**Event Trigger:** A user's ban was lifted

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:user_moderation_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:user_moderation_events`

**Event Model:**
```
type SNSUnbanEvent struct {
	UserID      string     `json:"user_id"`
	Timestamp   time.Time  `json:"timestamp"`
	UpdatedUser Properties `json:"updated_user"`
}
```

## update_user
**Event Trigger:** A user's property was updated

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:user_mutation_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:user_mutation_events`

**Event Model:**
```
type SNSUpdateEvent struct {
	UserID    string                `json:"user_id" `
	Original  *Properties           `json:"original" `
	Changed   *UpdateableProperties `json:"changed" `
	Timestamp time.Time             `json:"timestamp"`
}
```

## update_user_images
**Event Trigger:** A user's image metadata was set 

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:user_mutation_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:user_mutation_events`

**Event Model:**
```
type SNSUpdateImageEvent struct {
	UserID    string           `json:"user_id" `
	Original  *Properties      `json:"original" `
	Changed   *ImageProperties `json:"changed" `
	Timestamp time.Time        `json:"timestamp"`
}
```

## soft_delete_user
**Event Trigger:** A user was soft deleted 

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:user_soft_delete_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:user_soft_delete_events`

**Event Model:**
```
type SNSSoftDeleteEvent struct {
	UserID    string    `json:"user_id" `
	Timestamp time.Time `json:"timestamp"`
}
```

## hard_delete_user
**Event Trigger:** A user was hard deleted 

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:notification-user-destroyed`
* *Production:* `arn:aws:sns:us-west-2:641044725657:notification-user-destroyed`

**Event Model:**
```
type SNSHardDeleteEvent struct {
	UserID    string    `json:"user_id" `
	Timestamp time.Time `json:"timestamp"`
}
```

## undelete_user
**Event Trigger:** A soft delete user was restored

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:user_undelete_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:user_undelete_events`

**Event Model:**
```
type SNSUndeleteEvent struct {
	UserID    string    `json:"user_id" `
	Timestamp time.Time `json:"timestamp"`
}
```
## update_channel
**Event Trigger:** A channel property was set

**Topic ARNs:**
* *Staging:* `arn:aws:sns:us-west-2:465369119046:channel_mutation_events`
* *Production:* `arn:aws:sns:us-west-2:641044725657:channel_mutation_events`

**Event Model:**
```
type SNSChannelUpdateEvent struct {
	Original  *ChannelProperties       `json:"original"`
	Changes   *UpdateChannelProperties `json:"changes"`
	Timestamp time.Time                `json:"timestamp"`
}

```
