# New AWS Region

This outlines how to spin up users-service in a new region. The new network will be referenced as REGION throughout.

## Network

- Create a systems JIRA ticket requesting a network in REGION. [Here's an example for us-east-1](https://jira.twitch.com/browse/SYS-11085)

## Infrastructure

Once network is done, do the following:

- Create two directories `terraform/staging/REGION` and `terraform/production/REGION`.

For staging and production:

- `cd` into the environment/region directory
- Create a [main.tf](/terraform/staging/us-east-1/main.tf) and [bootstrap.sh](/terraform/staging/us-east-1/bootstrap.sh) in the new region folder. Be sure to change us-east-1 to the proper region and staging to the proper environment.
- Run `./bootstrap.sh`, `terraform plan` and `terraform apply`
- Create a beanstalk directory in the REGION directory and `cd` into it.
- Create a [main.tf](/terraform/staging/us-east-1/beanstalk/main.tf) and [bootstrap.sh](/terraform/staging/us-east-1/beanstalk/bootstrap.sh) in the new region folder. Be sure to change us-east-1 to the proper region and staging to the proper environment.
- Run `./bootstrap.sh`, `terraform plan` and `terraform apply`

## Configuration

- Add new configuration for the region, instructions can be found [here](https://git-aws.internal.justin.tv/web/users-service/blob/refactor-configs/doc/configuration.md#adding-environments-or-regions).
- Add the corresponding sandstorm roles [here](/main.go#L91).

## Deployment

- Add deploys to [deploy.json](/deploy.json), similar to [this](https://git-aws.internal.justin.tv/web/users-service/blob/master/deploy.json#L8-L19).
