# Testing

Changes to users service should be accompanied by tests.

## Best Practices 

### Do's

- Use the [golang testing package](https://golang.org/pkg/testing/).
- Use the [testify toolkit](https://github.com/stretchr/testify) for testing such as suite and assert.
- Use table driven tests via [t.Run](https://golang.org/pkg/testing/#hdr-Subtests_and_Sub_benchmarks). Here are [simple](https://git-aws.internal.justin.tv/web/users-service/blob/1e4ee7d64cc120d6c9e5db16f56ed165431a8ce9/logic/phone_number_test.go) and [complex](https://git-aws.internal.justin.tv/web/users-service/blob/f7738d04167d139c5b90f0978721bc12ad628dc1/logic/delete_test.go) examples.

### Don'ts

- Use [convey](https://github.com/smartystreets/goconvey)

## Integration Tests

Users Service is running an [integration test suite](https://git-aws.internal.justin.tv/web/users-service/tree/master/tools/integration) every time we build to ensure basic functionality is not impaired with the upcoming change. 

### Scope

Our integration tests explicitly calls users-service internal client and try to test:

- [Ban user flow](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/banuser_flow_tests.go) (ban user, unban user)
- [Create user flow](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/create_flow_tests.go)
- [Delete user flow](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/delete_flow_tests.go) (hard delete, soft delete, undelete)
- [DMCA strike flow](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/dmca_strike_flow_tests.go) (add DMCA strike and remove that)
- [Get channel with various of conditions](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/get_channels_flow_tests.go)
- [Get user with various of conditions](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/get_flow_tests.go)
- [Rename user flow](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/rename_flow_tests.go)
- [Set channel flow](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/set_channels_flow_tests.go)
- [Set user flow](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/setuser_flow_tests.go)

### Step

Integration test builds a separate environment to run users-service against. Here are the detailed steps we are following during a full integration test flow.

- Spin up DB and dump pre-designed data into it
- Spin up new Redis to support cache operaions
- Have [users](https://git-aws.internal.justin.tv/web/users-service/tree/master/internal/testutils/data) with various roles and specific data characteristics to operate on
- Run through flow via a fixed sequence. Sequence is important since even though we have separated different user for different suite of tests, but there are still small overlaps between them which requires some get testings to run first and set next.

### Tips

Everytime you add a new api/client, you should add integration tests to make sure that will be tested against during users-service build. You should:

- Make good use of our [safe expire](https://git-aws.internal.justin.tv/web/users-service/blob/master/tools/integration/tests/safe_expire.go) function to make sure have a clean cache when testing
- When you add a new schema, make sure to add to our [schema dumper](https://git-aws.internal.justin.tv/web/users-service/blob/master/db-data/01_schema_dump.sql)
- Add new data to both our [json]((https://git-aws.internal.justin.tv/web/users-service/tree/master/internal/testutils/data)) and [db script](https://git-aws.internal.justin.tv/web/users-service/tree/master/db-data) if new user/channel or field will be used.
- Our [test internal util package](https://git-aws.internal.justin.tv/web/users-service/blob/master/internal/testutils/) provides handy compare and diff function you will find handy.
