# User Images

User has three kinds of images, profile image, profile banner and channel offline image (video banner). Their metadata is stored in siteDB managed by users-service to help retrieve actual image location. 

## Where are images stored?

All images are stored in two S3 buckets, ttv-user-pictures-prod in twitch-web-aws account and jtv_user_pictures in emmett-shear account. All newly uploaded and recent images will be in twitch-web-aws account, while some legacy ones remain in emmett's account.

## Image metadata format

Image metadata is in YAML format and handled by [yimg package](https://git-aws.internal.justin.tv/common/yimg). Yimg package is in responsible to convert image metadata to YAMl, convert YAML back to metadata to help us retrive image and also decide standard image formats.

- Profile Image: Profile image are transformed into [7 sizes](https://git-aws.internal.justin.tv/common/yimg/blob/master/profile_image.go#L10) with retained ratio 1.0. The image should be cropped from the center of the image.

- Channel Offline Image: Channel offline image is always [1 size](https://git-aws.internal.justin.tv/common/yimg/blob/master/channel_offline_image.go#L10) when storing with ratio 16/9. But it is reformatted into different sizes when retrived from frontend, the reformatting is handled via a work together with twitch static and [aya](https://git-aws.internal.justin.tv/vod/aya).

- Profile Banner: Profile banner only cares about [height](https://git-aws.internal.justin.tv/common/yimg/blob/master/profile_banner.go#L10). It must be cut to 480 height via transforming and storing. And there is no limit on width.

All the images are either jpeg or png. If the original image uploaded is png, we'll preserve the quality by keeping the format. Otherwise, we transform to jpeg to have most space efficient solution.

## Image upload process

- User initiate a image upload request via frontend (either mobile or site).

- Request goes to Visage (upload image endpoint)[https://git-aws.internal.justin.tv/edge/visage/blob/master/api/v5/users/module.go#L27]

- Users service handles the request via [uploadUserImage](https://git-aws.internal.justin.tv/web/users-service/blob/master/api/api.go#L51) handler.

- Users service calculate transformation info based on image type and actual image properties.

- Users service talks to [upload service](https://git-aws.internal.justin.tv/web/upload-service) to request a signed S3 link for uploading with all the transformation info.

- Users service gets the upload URL back to frontend and frontend upload the image user selected.

- Users service worker constantly pulling from SQS to retrieve completed upload requests and do post-processing (assign the image metadata in siteDB and delete old images).

## Default user image

User could select a default image provided by us, and they are randomly assigned one if they don't have any profile image selected. The default image info is currently stored in users-service as a [binary](https://git-aws.internal.justin.tv/web/users-service/tree/master/internal/image), because we only have a small number of default images so we don't distribute them into database for performance consider.

- [User gets an assigned one if they don't have a profile image selected](https://git-aws.internal.justin.tv/web/users-service/blob/master/internal/image/reader.go#L118).

- [User has 7 different default images stored in S3 bucket](https://git-aws.internal.justin.tv/web/users-service/blob/master/internal/image/data/profile_images.json)

- User default image is stored as a string (image number) in siteDB as their metadata. 

## Frontend

Both mobile and site use the flow and knowledge mentioned above. For site part, our code is in [twilight edit profile components](https://git-aws.internal.justin.tv/twilight/twilight/tree/master/src/features/edit-profile/components).

## Future improvements

- We should be able to allow user to select the image format according to user needs. Or we could provide different formats which could make frontend load faster or with higher quality.

- User image should be cropped as a user's wish but not always fixed and cropped from the center with fixed transformation pattern. More flexibility should be provided.
 
