package mocks

import auth "code.justin.tv/web/users-service/internal/auth"
import context "golang.org/x/net/context"
import http "net/http"
import mock "github.com/stretchr/testify/mock"

// Decoder is an autogenerated mock type for the Decoder type
type Decoder struct {
	mock.Mock
}

// AuthorizeBulkUserRead provides a mock function with given fields: ctx, r, userID
func (_m *Decoder) AuthorizeBulkUserRead(ctx context.Context, r *http.Request, userID string) error {
	ret := _m.Called(ctx, r, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, string) error); ok {
		r0 = rf(ctx, r, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// AuthorizeChannelEdit provides a mock function with given fields: ctx, r, editor, channelID
func (_m *Decoder) AuthorizeChannelEdit(ctx context.Context, r *http.Request, editor string, channelID string) error {
	ret := _m.Called(ctx, r, editor, channelID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, string, string) error); ok {
		r0 = rf(ctx, r, editor, channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// AuthorizeUserEdit provides a mock function with given fields: ctx, r, userID
func (_m *Decoder) AuthorizeUserEdit(ctx context.Context, r *http.Request, userID string) error {
	ret := _m.Called(ctx, r, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, string) error); ok {
		r0 = rf(ctx, r, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// AuthorizeUserRead provides a mock function with given fields: ctx, r, userID
func (_m *Decoder) AuthorizeUserRead(ctx context.Context, r *http.Request, userID string) error {
	ret := _m.Called(ctx, r, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *http.Request, string) error); ok {
		r0 = rf(ctx, r, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ auth.Decoder = (*Decoder)(nil)
