package auditor

import (
	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/foundation/history-service/client/history"
	"golang.org/x/net/context"
)

type Auditor interface {
	Audit(ctx context.Context, ev *Event)
	Search(ctx context.Context, params *history.SearchParams) (*history.SearchResults, error)
}

type auditorImpl struct {
	client history.Client
}

func NewAuditor(clientConf twitchhttp.ClientConf) (Auditor, error) {
	c, err := history.NewClient(clientConf)
	if err != nil {
		return nil, err
	}
	return &auditorImpl{c}, err
}
