package events

import (
	"code.justin.tv/common/yimg"
	. "code.justin.tv/web/users-service/internal/clients/auditor"
	"code.justin.tv/web/users-service/models"
)

func UpdateImageEvent(userID string, updates models.ImageProperties) *Event {
	changes := []ChangeSet{}
	var cImage *string
	var pImage *string
	var pbImage *string
	if image, err := yimg.ChannelOfflineImagesToString(updates.ChannelOfflineImage); err == nil {
		cImage = image
	}

	if image, err := yimg.ProfileImagesToString(updates.ProfileImage); err == nil {
		pImage = image
	}

	if image, err := yimg.ProfileBannersToString(updates.ProfileBanner); err == nil {
		pbImage = image
	}

	if pbImage != nil {
		cs := ChangeSet{
			Attribute: ProfileBannerAttribute,
			New:       *pbImage,
		}
		changes = append(changes, cs)
	}

	if cImage != nil {
		cs := ChangeSet{
			Attribute: ChannelOfflineImageAttribute,
			New:       *cImage,
		}
		changes = append(changes, cs)
	}

	if pImage != nil {
		cs := ChangeSet{
			Attribute: ProfileImageAttribute,
			New:       *pImage,
		}
		changes = append(changes, cs)
	}

	return &Event{
		Action:       AttributeUpdate,
		UserID:       userID,
		ResourceType: DefaultUserType,
		ResourceID:   userID,
		Changes:      changes,
	}
}
