package events

import (
	"regexp"

	. "code.justin.tv/web/users-service/internal/clients/auditor"
)

func BanUserEvent(reporterID, userID, description string) *Event {
	reporterType := DefaultUserType
	match, err := regexp.MatchString("([a-z]+)", reporterID)
	if err != nil {
		reporterID = DefaultUserType
	} else if match {
		reporterType = LdapUser
	}
	return &Event{
		Action:       BanUser,
		UserType:     reporterType,
		UserID:       reporterID,
		ResourceType: DefaultUserType,
		ResourceID:   userID,
		Description:  description,
	}
}

func UnbanUserEvent(userID string) *Event {
	return &Event{
		Action:       UnbanUser,
		UserID:       userID,
		ResourceType: DefaultUserType,
		ResourceID:   userID,
	}
}
