package events_test

import (
	"testing"

	. "code.justin.tv/web/users-service/internal/clients/auditor"
	. "code.justin.tv/web/users-service/internal/clients/auditor/events"
	. "code.justin.tv/web/users-service/internal/testutils"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/suite"
)

type UserBanEventTest struct {
	suite.Suite
}

func (suite *UserBanEventTest) TestBuildUserBanEvent() {
	ev := BanUserEvent(AdminUserID, ToBanUserID, "bad user")
	expectedEvent := &Event{
		Action:       BanUser,
		UserType:     DefaultUserType,
		UserID:       AdminUserID,
		ResourceType: DefaultUserType,
		ResourceID:   ToBanUserID,
		Description:  "bad user",
	}
	assert.Equal(suite.T(), ev, expectedEvent)
}

func (suite *UserBanEventTest) TestBuildUserUnbanEvent() {
	ev := UnbanUserEvent(ToBanUserID)
	expectedEvent := &Event{
		Action:       UnbanUser,
		UserID:       ToBanUserID,
		ResourceType: DefaultUserType,
		ResourceID:   ToBanUserID,
	}
	assert.Equal(suite.T(), ev, expectedEvent)
}

func TestUserBanEventSuite(t *testing.T) {
	suite.Run(t, new(UserBanEventTest))
}
