package events

import (
	. "code.justin.tv/web/users-service/internal/clients/auditor"
)

func CreateUserEvent(userID, login string) *Event {
	changes := []ChangeSet{}
	cs := ChangeSet{
		Attribute: LoginAttribute,
		New:       login,
	}
	changes = append(changes, cs)
	return &Event{
		Action:       CreateUser,
		UserID:       userID,
		ResourceType: DefaultUserType,
		ResourceID:   userID,
		Changes:      changes,
	}
}
