package events

import "code.justin.tv/web/users-service/internal/clients/auditor"

func SoftDelete(userID, byLogin string) *auditor.Event {
	return &auditor.Event{
		Action:       auditor.SoftDeleteUser,
		UserType:     auditor.LdapUser,
		UserID:       byLogin,
		ResourceType: auditor.DefaultUserType,
		ResourceID:   userID,
	}
}

func HardDelete(userID, byLogin string) *auditor.Event {
	return &auditor.Event{
		Action:       auditor.HardDeleteUser,
		UserType:     auditor.LdapUser,
		UserID:       byLogin,
		ResourceType: auditor.DefaultUserType,
		ResourceID:   userID,
	}
}

func Undelete(userID, byLogin string) *auditor.Event {
	return &auditor.Event{
		Action:       auditor.UndeleteUser,
		UserType:     auditor.LdapUser,
		UserID:       byLogin,
		ResourceType: auditor.DefaultUserType,
		ResourceID:   userID,
	}
}
