package events

import (
	. "code.justin.tv/web/users-service/internal/clients/auditor"
	"code.justin.tv/web/users-service/models"
)

func UpdateUserEvent(old *models.Properties, new *models.UpdateableProperties) *Event {
	changes := []ChangeSet{}
	if attributeUpdated(old.Displayname, new.Displayname) {
		cs := ChangeSet{
			Attribute: DisplaynameAttribute,
			Old:       GetStringValue(old.Displayname),
			New:       GetStringValue(new.Displayname),
		}
		changes = append(changes, cs)
	}

	if attributeUpdated(old.Login, new.NewLogin) {
		cs := ChangeSet{
			Attribute: LoginAttribute,
			Old:       GetStringValue(old.Login),
			New:       GetStringValue(new.NewLogin),
		}
		changes = append(changes, cs)
	}

	if attributeUpdated(old.Email, new.Email) {
		cs := ChangeSet{
			Attribute: EmailAttribute,
			Old:       GetStringValue(old.Email),
			New:       GetStringValue(new.Email),
		}
		changes = append(changes, cs)
	}

	return &Event{
		Action:       AttributeUpdate,
		UserID:       old.ID,
		ResourceType: DefaultUserType,
		ResourceID:   old.ID,
		Changes:      changes,
	}
}

func attributeUpdated(oldAttr *string, newAttr *string) bool {
	if newAttr == nil {
		return false
	}

	if oldAttr == nil {
		return true
	}

	if *oldAttr != *newAttr {
		return true
	}

	return false
}
