package events_test

import (
	"testing"

	. "code.justin.tv/web/users-service/internal/clients/auditor"
	"code.justin.tv/web/users-service/internal/clients/auditor/events"
	. "code.justin.tv/web/users-service/internal/testutils"
	"code.justin.tv/web/users-service/models"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/suite"
)

type UserUpdateEventTest struct {
	suite.Suite
}

func (suite *UserUpdateEventTest) TestBuildUserUpdateEvent() {
	newEmail := "new_email@hotmail.com"
	newDisplayname := "newDisplayname"
	up := &models.UpdateableProperties{
		ID:          ToBanUserID,
		Email:       &newEmail,
		Displayname: &newDisplayname,
	}

	ev := events.UpdateUserEvent(Users[ToBanUserID], up)
	expectedEvent := &Event{
		Action:       AttributeUpdate,
		UserID:       ToBanUserID,
		ResourceType: DefaultUserType,
		ResourceID:   ToBanUserID,
		Changes: []ChangeSet{
			{Attribute: DisplaynameAttribute, Old: *Users[ToBanUserID].Displayname, New: newDisplayname},
			{Attribute: EmailAttribute, Old: *Users[ToBanUserID].Email, New: newEmail},
		},
	}
	assert.Equal(suite.T(), ev, expectedEvent)
}

func TestUserUpdateEventSuite(t *testing.T) {
	suite.Run(t, new(UserUpdateEventTest))
}
