package mocks

import banreport "code.justin.tv/web/users-service/internal/clients/banreport"
import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import twitchclient "code.justin.tv/foundation/twitchclient"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// ReportBan provides a mock function with given fields: ctx, ID, reportingID, banType, isWarning, banReason, reqOpts
func (_m *Client) ReportBan(ctx context.Context, ID string, reportingID string, banType string, isWarning bool, banReason string, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, ID, reportingID, banType, isWarning, banReason, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, bool, string, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, ID, reportingID, banType, isWarning, banReason, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ banreport.Client = (*Client)(nil)
