package mocks

import blacklist "code.justin.tv/web/blacklist"
import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import twitchhttp "code.justin.tv/common/twitchhttp"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// AddIP provides a mock function with given fields: ctx, IP, durationInSeconds, reqOpts
func (_m *Client) AddIP(ctx context.Context, IP string, durationInSeconds string, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, IP, durationInSeconds, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, IP, durationInSeconds, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteIP provides a mock function with given fields: ctx, IP, reqOpts
func (_m *Client) DeleteIP(ctx context.Context, IP string, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, IP, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, IP, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ValidateIP provides a mock function with given fields: ctx, IP, reqOpts
func (_m *Client) ValidateIP(ctx context.Context, IP string, reqOpts *twitchhttp.ReqOpts) (bool, error) {
	ret := _m.Called(ctx, IP, reqOpts)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) bool); ok {
		r0 = rf(ctx, IP, reqOpts)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, IP, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

var _ blacklist.Client = (*Client)(nil)
