package cacherwrapper

import (
	"errors"
	"strconv"
	"time"

	"fmt"

	rediserclient "code.justin.tv/identity/rediser/client"
	"github.com/go-redis/redis"
	"golang.org/x/net/context"
)

type RediserCacherImpl struct {
	rediserclient.Handler
}

func NewRediser(redis rediserclient.Handler) *RediserCacherImpl {
	return &RediserCacherImpl{redis}
}

func (r *RediserCacherImpl) Get(ctx context.Context, cacheKey string) (string, bool, error) {
	res, err := r.Handler.Get(ctx, cacheKey)
	if err != nil && err != redis.Nil {
		return "", false, err
	}
	return res, true, nil

}

func (r *RediserCacherImpl) MGet(ctx context.Context, cacheKeys ...string) ([]string, error) {
	strRes := make([]string, len(cacheKeys))
	results, err := r.Handler.PipelinedGet(ctx, cacheKeys...)

	if err != nil {
		return nil, err
	}
	for i, result := range results {
		if result != nil {
			strRes[i] = fmt.Sprint(result)
		} else {
			strRes[i] = ""
		}
	}
	return strRes, err
}

func (r *RediserCacherImpl) Del(ctx context.Context, keys ...string) (int, error) {
	result, err := r.Handler.PipelinedInvalidate(ctx, keys...)
	if err != nil {
		return 0, err
	}
	x := int(result)
	if int64(x) != result {
		return 0, strconv.ErrRange
	}
	return x, nil
}

func (r *RediserCacherImpl) MSetWithTTL(ctx context.Context, keys []string, values []string, ttl time.Duration) error {
	pairs, err := getKeyValuePairs(keys, values)
	if err != nil {
		return err
	}
	return r.Handler.MSetWithTTL(ctx, ttl, pairs...)
}

func (r *RediserCacherImpl) MSafeSetWithTTL(ctx context.Context, keys []string, values []string, ttl time.Duration) ([]bool, error) {
	pairs, err := getKeyValuePairs(keys, values)
	if err != nil {
		return nil, err
	}
	return nil, r.Handler.MSetNxWithTTL(ctx, ttl, pairs...)
}

func getKeyValuePairs(keys, values []string) ([]interface{}, error) {
	if len(keys) != len(values) {
		return nil, errors.New("len(keys) must equal len(values)")
	}
	pairs := make([]interface{}, len(keys)*2)
	for i, j := 0, 0; i < len(keys)*2; i, j = i+2, j+1 {
		pairs[i] = keys[j]
		pairs[i+1] = values[j]
	}
	return pairs, nil
}

func (r *RediserCacherImpl) Close() error {
	return r.Handler.Close()
}
