package memcacher

import (
	"crypto/sha512"
	"encoding/hex"
	"fmt"

	"code.justin.tv/foundation/gomemcache/memcache"
)

type Memcached interface {
	Get(key string) (item *memcache.Item, err error)
	GetMulti(keys []string) (map[string]*memcache.Item, error)
	Set(item *memcache.Item) error
	Add(item *memcache.Item) error
	Delete(key string) error
}

type CacherImpl struct {
	Memcache   Memcached
	Expiration int32
	Key        string
}

func New(memcache Memcached, key string) *CacherImpl {
	return &CacherImpl{
		Memcache:   memcache,
		Expiration: 30,
		Key:        key,
	}
}

func (c *CacherImpl) PropertiesByFieldCacheKey(field, identifier string) string {
	sha := sha512.Sum512([]byte(fmt.Sprintf("%s:%s:%s", c.Key, field, identifier)))
	return hex.EncodeToString(sha[:])
}

func (c *CacherImpl) Close() error {
	return nil
}
