package memcacher

import (
	"code.justin.tv/foundation/gomemcache/memcache"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
	"golang.org/x/sync/errgroup"
)

func (c *CacherImpl) ExpireProperties(ctx context.Context, prop models.Cacheable) error {
	if prop == nil {
		return nil
	}

	var g errgroup.Group
	for _, pair := range prop.CachePairs() {
		pair := pair
		g.Go(func() error {
			return c.deleteItem(c.PropertiesByFieldCacheKey(pair.Key, pair.Value))
		})
	}

	err := g.Wait()
	return err
}

func (c *CacherImpl) deleteItem(key string) error {
	err := c.Memcache.Delete(key)
	if err == memcache.ErrCacheMiss {
		err = nil
	}
	return err
}
