package memcacher

import (
	"encoding/json"
	"strings"

	"code.justin.tv/foundation/gomemcache/memcache"
	"code.justin.tv/web/users-service/backend"
	"golang.org/x/net/context"
)

func (c *CacherImpl) GetProperties(ctx context.Context, field, key string, prop interface{}) error {
	cacheKey := c.PropertiesByFieldCacheKey(field, key)

	item, err := c.Memcache.Get(cacheKey)
	if err != nil {
		if err == memcache.ErrCacheMiss {
			return backend.ErrCacheMiss
		} else {
			return err
		}
	}

	return json.Unmarshal(item.Value, prop)
}

func (c *CacherImpl) BulkGetProperties(ctx context.Context, field string, keys []string, e interface{}) ([]int, error) {
	hits := []string{}
	misses := []int{}
	cacheKeys := make([]string, len(keys))
	for i, key := range keys {
		cacheKeys[i] = c.PropertiesByFieldCacheKey(field, key)
	}
	cacheResults, err := c.Memcache.GetMulti(cacheKeys)
	if err != nil {
		return misses, err
	}

	for i, key := range keys {
		cacheKey := c.PropertiesByFieldCacheKey(field, key)
		if cacheResults[cacheKey] == nil {
			misses = append(misses, i)
		} else {
			hits = append(hits, string(cacheResults[cacheKey].Value))
		}
	}

	commaSeparated := strings.Join(hits, ",")
	jsonStr := "[" + commaSeparated + "]"

	return misses, json.Unmarshal([]byte(jsonStr), e)
}
