package mocks

import memcache "code.justin.tv/foundation/gomemcache/memcache"
import memcacher "code.justin.tv/web/users-service/internal/clients/cache/memcacher"
import mock "github.com/stretchr/testify/mock"

// Memcached is an autogenerated mock type for the Memcached type
type Memcached struct {
	mock.Mock
}

// Add provides a mock function with given fields: item
func (_m *Memcached) Add(item *memcache.Item) error {
	ret := _m.Called(item)

	var r0 error
	if rf, ok := ret.Get(0).(func(*memcache.Item) error); ok {
		r0 = rf(item)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Delete provides a mock function with given fields: key
func (_m *Memcached) Delete(key string) error {
	ret := _m.Called(key)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(key)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Get provides a mock function with given fields: key
func (_m *Memcached) Get(key string) (*memcache.Item, error) {
	ret := _m.Called(key)

	var r0 *memcache.Item
	if rf, ok := ret.Get(0).(func(string) *memcache.Item); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*memcache.Item)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMulti provides a mock function with given fields: keys
func (_m *Memcached) GetMulti(keys []string) (map[string]*memcache.Item, error) {
	ret := _m.Called(keys)

	var r0 map[string]*memcache.Item
	if rf, ok := ret.Get(0).(func([]string) map[string]*memcache.Item); ok {
		r0 = rf(keys)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]*memcache.Item)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]string) error); ok {
		r1 = rf(keys)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Set provides a mock function with given fields: item
func (_m *Memcached) Set(item *memcache.Item) error {
	ret := _m.Called(item)

	var r0 error
	if rf, ok := ret.Get(0).(func(*memcache.Item) error); ok {
		r0 = rf(item)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ memcacher.Memcached = (*Memcached)(nil)
