package rediscacher

import (
	"testing"
	"time"

	"code.justin.tv/chat/redis"
	mocksns "code.justin.tv/web/users-service/internal/clients/sns/mocks"
	. "code.justin.tv/web/users-service/internal/testutils"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

type ExpireTest struct {
	suite.Suite
	mockRedis *redis.MockRedis
	mocksns   *mocksns.Publisher
	cb        *CacherImpl
}

func (suite *ExpireTest) SetupTest() {
	suite.mockRedis = &redis.MockRedis{}
	suite.mocksns = &mocksns.Publisher{}

	suite.cb = &CacherImpl{
		redis:       suite.mockRedis,
		redisBackup: suite.mockRedis,
		cacheTTLMS:  time.Minute,
		key:         "user-props-string",
		sns:         suite.mocksns,
	}
}

func (suite *ExpireTest) TestExpireUserProperties() {
	suite.mockRedis.On("Del", mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(1, nil).Times(2)
	suite.mocksns.On("PublishExpireCache", mock.Anything, mock.Anything).Return(nil)
	err := suite.cb.ExpireProperties(context.Background(), Users[ToBanUserID])
	time.Sleep(1 * time.Second)
	assert.NoError(suite.T(), err)
}

func (suite *ExpireTest) TestExpireExistingNilUserProperties() {
	err := suite.cb.ExpireProperties(context.Background(), nil)
	assert.NoError(suite.T(), err)
}

func TestExpireSuite(t *testing.T) {
	suite.Run(t, new(ExpireTest))
}
