package mocks

import context "golang.org/x/net/context"
import discovery "code.justin.tv/web/users-service/internal/clients/discovery"
import mock "github.com/stretchr/testify/mock"

// Discovery is an autogenerated mock type for the Discovery type
type Discovery struct {
	mock.Mock
}

// GetGameIDByName provides a mock function with given fields: ctx, game
func (_m *Discovery) GetGameIDByName(ctx context.Context, game string) (int, error) {
	ret := _m.Called(ctx, game)

	var r0 int
	if rf, ok := ret.Get(0).(func(context.Context, string) int); ok {
		r0 = rf(ctx, game)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, game)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

var _ discovery.Discovery = (*Discovery)(nil)
