package mocks

import "code.justin.tv/feeds/following-service/client/follows"
import "github.com/stretchr/testify/mock"

import "golang.org/x/net/context"
import "code.justin.tv/common/twitchhttp"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// Follow provides a mock function with given fields: ctx, fromUserID, targetUserID, body, opts
func (_m *Client) Follow(ctx context.Context, fromUserID string, targetUserID string, body *follows.FollowRequestBody, opts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, fromUserID, targetUserID, body, opts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *follows.FollowRequestBody, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, fromUserID, targetUserID, body, opts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetFollow provides a mock function with given fields: ctx, fromUserID, targetUserID, opts
func (_m *Client) GetFollow(ctx context.Context, fromUserID string, targetUserID string, opts *twitchhttp.ReqOpts) (*follows.Follow, error) {
	ret := _m.Called(ctx, fromUserID, targetUserID, opts)

	var r0 *follows.Follow
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchhttp.ReqOpts) *follows.Follow); ok {
		r0 = rf(ctx, fromUserID, targetUserID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*follows.Follow)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, fromUserID, targetUserID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// HideAllFollows provides a mock function with given fields: ctx, userID, opts
func (_m *Client) HideAllFollows(ctx context.Context, userID string, opts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, userID, opts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, userID, opts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListFollowers provides a mock function with given fields: ctx, fromUserID, params, opts
func (_m *Client) ListFollowers(ctx context.Context, fromUserID string, params *follows.ListFollowersParams, opts *twitchhttp.ReqOpts) (*follows.Followers, error) {
	ret := _m.Called(ctx, fromUserID, params, opts)

	var r0 *follows.Followers
	if rf, ok := ret.Get(0).(func(context.Context, string, *follows.ListFollowersParams, *twitchhttp.ReqOpts) *follows.Followers); ok {
		r0 = rf(ctx, fromUserID, params, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*follows.Followers)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *follows.ListFollowersParams, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, fromUserID, params, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListFollows provides a mock function with given fields: ctx, fromUserID, params, opts
func (_m *Client) ListFollows(ctx context.Context, fromUserID string, params *follows.ListFollowsParams, opts *twitchhttp.ReqOpts) (*follows.Follows, error) {
	ret := _m.Called(ctx, fromUserID, params, opts)

	var r0 *follows.Follows
	if rf, ok := ret.Get(0).(func(context.Context, string, *follows.ListFollowsParams, *twitchhttp.ReqOpts) *follows.Follows); ok {
		r0 = rf(ctx, fromUserID, params, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*follows.Follows)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *follows.ListFollowsParams, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, fromUserID, params, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RestoreAllFollows provides a mock function with given fields: ctx, userID, opts
func (_m *Client) RestoreAllFollows(ctx context.Context, userID string, opts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, userID, opts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, userID, opts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Unfollow provides a mock function with given fields: ctx, fromUserID, targetUserID, opts
func (_m *Client) Unfollow(ctx context.Context, fromUserID string, targetUserID string, opts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, fromUserID, targetUserID, opts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, fromUserID, targetUserID, opts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
