package mocks

import geoip "code.justin.tv/web/users-service/internal/clients/geoip"
import mock "github.com/stretchr/testify/mock"

// GeoIP is an autogenerated mock type for the GeoIP type
type GeoIP struct {
	mock.Mock
}

// GetCountry provides a mock function with given fields: ip
func (_m *GeoIP) GetCountry(ip string) (string, int) {
	ret := _m.Called(ip)

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(ip)
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 int
	if rf, ok := ret.Get(1).(func(string) int); ok {
		r1 = rf(ip)
	} else {
		r1 = ret.Get(1).(int)
	}

	return r0, r1
}

var _ geoip.GeoIP = (*GeoIP)(nil)
