package kinesis

import (
	"time"

	"code.justin.tv/web/users-service/models"

	"github.com/satori/go.uuid"
)

/*type Event struct {
	Type      string    `json:"type"`
	UserID    string    `json:"user_id"`
	Data      eventData `json:"changes,omitempty"`
	Timestamp time.Time `json:"timestamp"`
}*/
type Event struct {
	Type      string     `json:"type"`
	UserID    string     `json:"user_id"`
	Data      *EventData `json:"data"`
	Timestamp time.Time  `json:"timestamp"`
}

type EventData struct {
	Original *models.Properties  `json:"original"`
	Changes  *MutationProperties `json:"changes"`
}

type MutationProperties struct {
	Login       *string `json:"login,omitempty"`
	Displayname *string `json:"displayname,omitempty"`
}

const (
	loginChange       = "user_login_change"
	displaynameChange = "displayname_change"
)

func (e Event) EventType() string {
	return e.Type
}

func (e Event) PartitionKey() string {
	return uuid.NewV4().String()
}

func NewLoginChangedEvent(id string, original *models.Properties, changes *models.UpdateableProperties) Event {

	var changedProperties MutationProperties

	if changes.NewLogin != nil && *changes.NewLogin != *original.Login {
		changedProperties.Login = changes.NewLogin
	}

	if changes.Displayname != nil && *changes.Displayname != *original.Displayname {
		changedProperties.Displayname = changes.Displayname
	}

	changeData := EventData{
		Original: original,
		Changes:  &changedProperties,
	}

	return Event{
		Type:      loginChange,
		UserID:    id,
		Data:      &changeData,
		Timestamp: time.Now(),
	}
}

func NewDisplaynameChangedEvent(id string, original *models.Properties, changes *models.UpdateableProperties) Event {

	var changedProperties MutationProperties

	if changes.Displayname != nil && *changes.Displayname != *original.Displayname {
		changedProperties.Displayname = changes.Displayname
	}

	changeData := EventData{
		Original: original,
		Changes:  &changedProperties,
	}

	return Event{
		Type:      displaynameChange,
		UserID:    id,
		Data:      &changeData,
		Timestamp: time.Now(),
	}
}
