package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import oauth2 "code.justin.tv/web/owl/oauth2"
import owl "code.justin.tv/web/owl/client"
import twitchhttp "code.justin.tv/common/twitchhttp"
import url "net/url"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// Authorizations provides a mock function with given fields: ctx, ownerID, reqOpts
func (_m *Client) Authorizations(ctx context.Context, ownerID string, reqOpts *twitchhttp.ReqOpts) (*owl.AuthorizationsResponse, error) {
	ret := _m.Called(ctx, ownerID, reqOpts)

	var r0 *owl.AuthorizationsResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) *owl.AuthorizationsResponse); ok {
		r0 = rf(ctx, ownerID, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*owl.AuthorizationsResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, ownerID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Authorize provides a mock function with given fields: ctx, authReq, reqOpts
func (_m *Client) Authorize(ctx context.Context, authReq url.Values, reqOpts *twitchhttp.ReqOpts) (owl.Token, error) {
	ret := _m.Called(ctx, authReq, reqOpts)

	var r0 owl.Token
	if rf, ok := ret.Get(0).(func(context.Context, url.Values, *twitchhttp.ReqOpts) owl.Token); ok {
		r0 = rf(ctx, authReq, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(owl.Token)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, url.Values, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, authReq, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ClientInfo provides a mock function with given fields: ctx, clientID, reqOpts
func (_m *Client) ClientInfo(ctx context.Context, clientID string, reqOpts *twitchhttp.ReqOpts) (*owl.ClientData, error) {
	ret := _m.Called(ctx, clientID, reqOpts)

	var r0 *owl.ClientData
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) *owl.ClientData); ok {
		r0 = rf(ctx, clientID, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*owl.ClientData)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, clientID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateAuthorization provides a mock function with given fields: ctx, ownerID, clientID, scopes, reqOpts
func (_m *Client) CreateAuthorization(ctx context.Context, ownerID string, clientID string, scopes []string, reqOpts *twitchhttp.ReqOpts) (*owl.TokenResponse, error) {
	ret := _m.Called(ctx, ownerID, clientID, scopes, reqOpts)

	var r0 *owl.TokenResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, string, []string, *twitchhttp.ReqOpts) *owl.TokenResponse); ok {
		r0 = rf(ctx, ownerID, clientID, scopes, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*owl.TokenResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, []string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, ownerID, clientID, scopes, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteAllSessions provides a mock function with given fields: ctx, ownerID, reqOpts
func (_m *Client) DeleteAllSessions(ctx context.Context, ownerID string, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, ownerID, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, ownerID, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ExchangeAuthorizationCode provides a mock function with given fields: ctx, clientID, clientSecret, code, redirectURI, reqOpts
func (_m *Client) ExchangeAuthorizationCode(ctx context.Context, clientID string, clientSecret string, code string, redirectURI string, reqOpts *twitchhttp.ReqOpts) (*owl.TokenResponse, error) {
	ret := _m.Called(ctx, clientID, clientSecret, code, redirectURI, reqOpts)

	var r0 *owl.TokenResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, string, *twitchhttp.ReqOpts) *owl.TokenResponse); ok {
		r0 = rf(ctx, clientID, clientSecret, code, redirectURI, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*owl.TokenResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, string, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, clientID, clientSecret, code, redirectURI, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetClient provides a mock function with given fields: ctx, clientID, reqOpts
func (_m *Client) GetClient(ctx context.Context, clientID string, reqOpts *twitchhttp.ReqOpts) (*oauth2.Client, error) {
	ret := _m.Called(ctx, clientID, reqOpts)

	var r0 *oauth2.Client
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) *oauth2.Client); ok {
		r0 = rf(ctx, clientID, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*oauth2.Client)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, clientID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetClientByRowID provides a mock function with given fields: ctx, clientRowID, reqOpts
func (_m *Client) GetClientByRowID(ctx context.Context, clientRowID string, reqOpts *twitchhttp.ReqOpts) (*oauth2.Client, error) {
	ret := _m.Called(ctx, clientRowID, reqOpts)

	var r0 *oauth2.Client
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) *oauth2.Client); ok {
		r0 = rf(ctx, clientRowID, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*oauth2.Client)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, clientRowID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetClients provides a mock function with given fields: ctx, cursor, showHidden, filters, sKey, sOrder, reqOpts
func (_m *Client) GetClients(ctx context.Context, cursor string, showHidden bool, filters map[owl.FilterableColumn]string, sKey owl.SortKey, sOrder owl.SortOrder, reqOpts *twitchhttp.ReqOpts) ([]*oauth2.Client, string, error) {
	ret := _m.Called(ctx, cursor, showHidden, filters, sKey, sOrder, reqOpts)

	var r0 []*oauth2.Client
	if rf, ok := ret.Get(0).(func(context.Context, string, bool, map[owl.FilterableColumn]string, owl.SortKey, owl.SortOrder, *twitchhttp.ReqOpts) []*oauth2.Client); ok {
		r0 = rf(ctx, cursor, showHidden, filters, sKey, sOrder, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*oauth2.Client)
		}
	}

	var r1 string
	if rf, ok := ret.Get(1).(func(context.Context, string, bool, map[owl.FilterableColumn]string, owl.SortKey, owl.SortOrder, *twitchhttp.ReqOpts) string); ok {
		r1 = rf(ctx, cursor, showHidden, filters, sKey, sOrder, reqOpts)
	} else {
		r1 = ret.Get(1).(string)
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string, bool, map[owl.FilterableColumn]string, owl.SortKey, owl.SortOrder, *twitchhttp.ReqOpts) error); ok {
		r2 = rf(ctx, cursor, showHidden, filters, sKey, sOrder, reqOpts)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// Validate provides a mock function with given fields: ctx, token, scopes, reqOpts
func (_m *Client) Validate(ctx context.Context, token string, scopes []string, reqOpts *twitchhttp.ReqOpts) (*oauth2.Authorization, error) {
	ret := _m.Called(ctx, token, scopes, reqOpts)

	var r0 *oauth2.Authorization
	if rf, ok := ret.Get(0).(func(context.Context, string, []string, *twitchhttp.ReqOpts) *oauth2.Authorization); ok {
		r0 = rf(ctx, token, scopes, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*oauth2.Authorization)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, []string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, token, scopes, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ValidateSecret provides a mock function with given fields: ctx, clientID, clientSecret, reqOpts
func (_m *Client) ValidateSecret(ctx context.Context, clientID string, clientSecret string, reqOpts *twitchhttp.ReqOpts) (bool, error) {
	ret := _m.Called(ctx, clientID, clientSecret, reqOpts)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchhttp.ReqOpts) bool); ok {
		r0 = rf(ctx, clientID, clientSecret, reqOpts)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, clientID, clientSecret, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

var _ owl.Client = (*Client)(nil)
