package mocks

import context "context"
import mock "github.com/stretchr/testify/mock"
import partnerships "code.justin.tv/web/users-service/internal/clients/partnerships"
import moneypenny "code.justin.tv/revenue/moneypenny/client"

import twitchclient "code.justin.tv/foundation/twitchclient"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// CheckPartneredByUserID provides a mock function with given fields: _a0, _a1, _a2
func (_m *Client) CheckPartneredByUserID(_a0 context.Context, _a1 string, _a2 *twitchclient.ReqOpts) (bool, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) bool); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserPayoutType provides a mock function with given fields: _a0, _a1, _a2
func (_m *Client) GetUserPayoutType(_a0 context.Context, _a1 string, _a2 *twitchclient.ReqOpts) (*moneypenny.GetUserPayoutTypeResponse, error) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *moneypenny.GetUserPayoutTypeResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) *moneypenny.GetUserPayoutTypeResponse); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*moneypenny.GetUserPayoutTypeResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

var _ partnerships.Client = (*Client)(nil)
