package partnerships

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	moneypenny "code.justin.tv/revenue/moneypenny/client"
)

func NewMoneyPennyClient(conf twitchclient.ClientConf) (Client, error) {
	c, err := moneypenny.NewClient(conf)
	if err != nil {
		return nil, err
	}

	return &HystrixClient{
		client: &MoneyPennyClient{
			client: c,
		},
	}, nil
}

type MoneyPennyClient struct {
	client moneypenny.Client
}

func (c *MoneyPennyClient) CheckPartneredByUserID(ctx context.Context, userID string, reqOpts *twitchclient.ReqOpts) (bool, error) {
	resp, err := c.client.GetUserPayoutType(ctx, userID, nil)
	if err != nil {
		return false, err
	}

	return resp.IsPartner, nil
}

func (c *MoneyPennyClient) GetUserPayoutType(ctx context.Context, userID string, reqOpts *twitchclient.ReqOpts) (*moneypenny.GetUserPayoutTypeResponse, error) {
	resp, err := c.client.GetUserPayoutType(ctx, userID, nil)
	if err != nil {
		return nil, err
	}

	return resp, nil
}
