package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"
import pubsub "code.justin.tv/web/users-service/internal/clients/pubsub"

// PubSub is an autogenerated mock type for the PubSub type
type PubSub struct {
	mock.Mock
}

// Publish provides a mock function with given fields: ctx, topic, event
func (_m *PubSub) Publish(ctx context.Context, topic []string, event models.PubSubEvent) error {
	ret := _m.Called(ctx, topic, event)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []string, models.PubSubEvent) error); ok {
		r0 = rf(ctx, topic, event)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ pubsub.PubSub = (*PubSub)(nil)
