package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import rails "code.justin.tv/web/users-service/internal/clients/rails"
import twitchclient "code.justin.tv/foundation/twitchclient"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// DeleteCache provides a mock function with given fields: ctx, ID, reqOpts
func (_m *Client) DeleteCache(ctx context.Context, ID string, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, ID, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, ID, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// HardDeleteUser provides a mock function with given fields: ctx, ID, adminLogin, reqOpts
func (_m *Client) HardDeleteUser(ctx context.Context, ID string, adminLogin string, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, ID, adminLogin, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, ID, adminLogin, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SendEmail provides a mock function with given fields: ctx, ID, emailName, emailAddress, emailArgs
func (_m *Client) SendEmail(ctx context.Context, ID string, emailName string, emailAddress string, emailArgs interface{}) error {
	ret := _m.Called(ctx, ID, emailName, emailAddress, emailArgs)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, interface{}) error); ok {
		r0 = rf(ctx, ID, emailName, emailAddress, emailArgs)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SoftDeleteUser provides a mock function with given fields: ctx, ID, reqOpts
func (_m *Client) SoftDeleteUser(ctx context.Context, ID string, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, ID, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, ID, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UndeleteUser provides a mock function with given fields: ctx, ID, reqOpts
func (_m *Client) UndeleteUser(ctx context.Context, ID string, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, ID, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, ID, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// VodSync provides a mock function with given fields: ctx, ID, reqOpts
func (_m *Client) VodSync(ctx context.Context, ID string, reqOpts *twitchclient.ReqOpts) error {
	ret := _m.Called(ctx, ID, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r0 = rf(ctx, ID, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ rails.Client = (*Client)(nil)
